% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_ppod}
\alias{comp_ppod}
\title{Compute the proportion of positive decisions (ppod) from probabilities.}
\usage{
comp_ppod(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
The proportion of positive decisions \code{\link{ppod}} as a probability.
A warning is provided for NaN values.
}
\description{
\code{comp_ppod} computes the proportion of positive decisions \code{\link{ppod}}
from 3 essential probabilities
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}.
}
\details{
\code{comp_ppod} uses probabilities (not frequencies) as
inputs and returns a proportion (probability)
without rounding.

Definition: \code{ppod} is
proportion (or probability) of positive decisions:

\code{ppod = dec.pos/N = (hi + fa)/(hi + mi + fa + cr)}

Values range from 0 (only negative decisions)
to 1 (only positive decisions).

Importantly, positive decisions \code{\link{dec.pos}}
are not necessariliy correct decisions \code{\link{dec.cor}}.
}
\examples{
# (1) ways to work:
comp_ppod(.10, .200, .300)  # => ppod = 0.65
comp_ppod(.50, .333, .666)  # => ppod = 0.3335

# (2) watch out for vectors:
prev <- seq(0, 1, .1)
comp_ppod(prev, .8, .5)  # => 0.50 0.53 0.56 0.59 0.62 0.65 0.68 0.71 0.74 0.77 0.80
comp_ppod(prev,  0,  1)  # => 0 0 0 0 0 0 0 0 0 0 0

# (3) watch out for extreme values:
comp_ppod(1, 1, 1)  #  => 1
comp_ppod(1, 1, 0)  #  => 1

comp_ppod(1, 0, 1)  #  => 0
comp_ppod(1, 0, 0)  #  => 0

comp_ppod(0, 1, 1)  #  => 0
comp_ppod(0, 1, 0)  #  => 1

comp_ppod(0, 0, 1)  #  => 0
comp_ppod(0, 0, 0)  #  => 1


}
\seealso{
\code{\link{comp_sens}} and \code{\link{comp_NPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu}},
  \code{\link{comp_acc}}, \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_prob_freq}}, \code{\link{comp_prob}},
  \code{\link{comp_sens}}, \code{\link{comp_spec}}
}
