% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_risk_diff.R
\name{print.riskdiff_result}
\alias{print.riskdiff_result}
\title{Print method for riskdiff_result objects}
\usage{
\method{print}{riskdiff_result}(x, show_boundary = TRUE, ...)
}
\arguments{
\item{x}{A riskdiff_result object from calc_risk_diff()}

\item{show_boundary}{Logical, whether to show boundary information when available (default: TRUE)}

\item{...}{Additional arguments passed to print methods}
}
\value{
Invisibly returns the original riskdiff_result object (x). Called primarily
for its side effect of printing formatted results to the console.
}
\description{
Prints risk difference results in a formatted, readable way showing
key statistics including risk differences, confidence intervals, and
model types used. Version 0.2.0+ includes boundary case detection.
}
\examples{
data(cachar_sample)
result <- calc_risk_diff(cachar_sample, "abnormal_screen", "smoking")
print(result)

# Show boundary information if available
print(result, show_boundary = TRUE)

}
