% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IC_Nelson_Aalen_cens_time}
\alias{IC_Nelson_Aalen_cens_time}
\title{Influence function for Nelson-Aalen estimator.}
\usage{
IC_Nelson_Aalen_cens_time(time, status)
}
\arguments{
\item{time}{sorted vector of event times. Sorted according to time and -status so that events come first a tied times.}

\item{status}{sorted vector of 0 = censored or 1 = event (any cause). Sorted according to time and -status so that events come first a tied times.}
}
\value{
A square matrix where each column corresponds to a subject and each row to a time point.
}
\description{
Fast computation of influence function for Nelson-Aalen estimator of the censoring times
}
\examples{
time = c(1,3,3,4)
status = c(1,0,1,1)
IC_Nelson_Aalen_cens_time(time,status)
}
\author{
Thomas Alexander Gerds <tag@biostat.ku.dk>
}
