% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ateRobust.R
\name{ateRobust}
\alias{ateRobust}
\title{Average Treatment Effects (ATE) for survival outcome (with competing risks) using doubly robust estimating equations}
\usage{
ateRobust(data, times, cause, type, formula.event, formula.censor,
  formula.treatment, fitter = "coxph", product.limit = NULL,
  se = TRUE, augment.cens = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{[data.frame or data.table] Data set in which to evaluate the ATE.}

\item{times}{[numeric] Time point at which to evaluate average treatment effects.}

\item{cause}{[numeric/character] The cause of interest. Defaults to the first cause.}

\item{type}{[character] When set to \code{"survival"} uses a cox model for modeling the survival,
otherwise when set to \code{"competing.risks"} uses a Cause Specific Cox model for modeling the absolute risk of the event.}

\item{formula.event}{[formula] Cox model for the event of interest (outcome model).
Typically \code{Surv(time,event)~treatment}.}

\item{formula.censor}{[formula] Cox model for the censoring (censoring model).
Typically \code{Surv(time,event==0)~treatment}.}

\item{formula.treatment}{[formula] Logistic regression for the treatment (propensity score model).
Typically \code{treatment~1}.}

\item{fitter}{[character] Routine to fit the Cox regression models.
If \code{coxph} use \code{survival::coxph} else use \code{rms::cph}.}

\item{product.limit}{[logical] If \code{TRUE} the survival is computed using the product limit method.
Otherwise the exponential approximation is used (i.e. exp(-cumulative hazard)).}

\item{se}{[logical] If \code{TRUE} compute and add the standard errors relative to the G-formula and IPTW method to the output.}

\item{augment.cens}{[logical] If \code{TRUE} add an censoring model augmentation term to the estimating equation}

\item{na.rm}{[logical] If \code{TRUE} ignore observations whose influence function is NA.}
}
\description{
Compute the average treatment effect using different methods:
G-formula based on (cause-specific) Cox regression, inverse probability of treatment weighting (IPTW)
combined with inverse probability of censoring weighting (IPCW), augmented inverse probability weighting (AIPTW, AIPCW).
}
\examples{
library(survival)
library(lava)
library(data.table)

set.seed(10)
# survival outcome, binary treatment X1 

ds <- sampleData(101,outcome="survival")
out <- ateRobust(data = ds, type = "survival",
          formula.event = Surv(time, event) ~ X1+X6,
         formula.censor = Surv(time, event==0) ~ X6,
         formula.treatment = X1 ~ X6+X2+X7, times = 1)
out
dt.out=as.data.table(out)
dt.out

# competing risk outcome, binary treatment X1 
dc=sampleData(101,outcome="competing.risks")
x=ateRobust(data = dc, type = "competing.risks",
          formula.event = list(Hist(time, event) ~ X1+X6,Hist(time, event) ~ X6),
         formula.censor = Surv(time, event==0) ~ X6,
         formula.treatment = X1 ~ X6+X2+X7, times = 1,cause=1,
                     product.limit = FALSE)
## compare with g-formula 
fit= CSC(list(Hist(time, event) ~ X1+X6,Hist(time, event) ~ X6),data=dc)
ate(fit,data = dc,treatment="X1",times=1,cause=1)
x
as.data.table(x)
}
\seealso{
\code{\link{ate}} for the g-formula result in case of more than 2 treatments
}
