% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHom.R
\name{is.PHom}
\alias{is.PHom}
\title{Check PHom Object}
\usage{
is.PHom(x)
}
\arguments{
\item{x}{object whose \code{PHom}-ness is being tested}
}
\value{
\code{TRUE} if \code{x} is a valid \code{PHom} object; \code{FALSE} otherwise
}
\description{
Tests if objects are valid \code{PHom} instances.
}
\examples{
# create sample persistence data
df <- data.frame(dimension = c(0, 0, 1, 1, 1, 2),
                 birth = rnorm(6),
                 death = rnorm(6, mean = 15))
df <- as.PHom(df)

# confirm that persistence data is valid
is.PHom(df)

# mess up df object (feature birth cannot be after death)
df$birth[1] <- rnorm(1, mean = 50)

# confirm that persistence data is NOT valid
is.PHom(df)
}
