% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{earthquakes}
\alias{earthquakes}
\title{Japanese earthquakes dataset}
\format{
A data frame with 678 rows and 2 variables:
\describe{
  \item{theta1}{Direction of steepest descent.}
  \item{theta2}{Direction of lateral ground movement.}
}
}
\usage{
earthquakes
}
\description{
Pre-earthquake direction of steepest descent and the direction
of lateral ground movement before and after, respectively, an earthquake in
Noshiro (Japan) in 1983.
}
\details{
The direction is measured in radians in \eqn{[0, 2\pi)} with \eqn{0} /
\eqn{\frac{\pi}{2}} / \eqn{\pi} / \eqn{\frac{3\pi}{2}} / \eqn{2\pi}
representing the East / North / West / South / East directions.
}
\examples{
# Load data
data("earthquakes")

# Transform the data into [-pi, pi)
earthquakes <- sdetorus::toPiInt(earthquakes)
plot(earthquakes, xlab = expression(theta[1]), ylab = expression(theta[2]),
     xlim = c(-pi, pi), ylim = c(-pi, pi), axes = FALSE)
sdetorus::torusAxis()

\donttest{
# Perform TR-PCA
fit <- ridge_pca(x = earthquakes)
show_ridge_pca(fit)}
}
\references{
Hamada, M. and O'Rourke, T. (1992). Case Studies of Liquefaction & Lifeline
Performance During Past Earthquake. Volume 1: Japanese Case Studies.
Technical Report NCEER-92-0001. National Center for Earthquake Engineering
Research, University at Buffalo. \doi{10.1016/0886-7798(93)90146-m}

Jones, M. C., Pewsey, A., and Kato, S. (2015). On a class of circulas:
copulas for circular distributions. \emph{Annals of the Institute of
Statistical Mathematics}, 67(5):843--862. \doi{10.1007/s10463-014-0493-6}

Rivest, L.-P. (1997). A decentred predictor for circular-circular
regression. \emph{Biometrika}, 84(3):717--726. \doi{10.1093/biomet/84.3.717}
}
\keyword{datasets}
