% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{santabarbara}
\alias{santabarbara}
\title{Santa Barbara currents}
\format{
A data frame with 1092 rows and 4 variables:
\describe{
  \item{A}{Sea current direction at zone A.}
  \item{B}{Sea current direction at zone B.}
  \item{C}{Sea current direction at zone C.}
  \item{D}{Sea current direction at zone D.}
}
}
\usage{
santabarbara
}
\description{
The Santa Barbara Channel is a coastal area in California. This
dataset contains the sea currents in the four areas present in the
data application in García-Portugués and Prieto-Tirado (2022). Precisely,
it contains the 24-hour speed-weighted mean of the currents' direction in
each of the four areas downloaded from the
\href{https://hfradar.ndbc.noaa.gov/}{
NOAA High Frequency Radar National Server}.
}
\details{
The selection of these four areas is motivated by previous studies on the
Santa Barbara currents, like Auad et al. (1998). The direction is measured
in radians in \eqn{[-\pi, \pi)} with \eqn{-\pi} / \eqn{-\frac{\pi}{2}} /
\eqn{0} / \eqn{\frac{\pi}{2}} / \eqn{\pi} representing the
East / South / West / North / East directions. The script performing the data
preprocessing is available at
\href{https://github.com/egarpor/ridgetorus/blob/master/data-raw/data-acquisition.R}{
\code{data-acquisition.R}}. The data was retrieved on 2022-10-21.
}
\examples{
# Load data
data("santabarbara")
AB_zone <- santabarbara[c("A","B")]

\donttest{
# Perform TR-PCA
fit <- ridge_pca(x = AB_zone)
show_ridge_pca(fit)}
}
\references{
Auad, G., Hendershott, M. C., and Winant, C. D. (1998). Wind-induced currents
and bottom-trapped waves in the Santa Barbara Channel. \emph{Journal of
Physical Oceanography}, 28(1):85--102.
\doi{10.1175/1520-0485(1998)028<0085:WICABT>2.0.CO;2}

García-Portugués, E. and Prieto-Tirado, A. (2022). Toroidal PCA via density
ridges. \emph{arXiv:2212.10856}. \url{https://arxiv.org/abs/2212.10856}
}
\keyword{datasets}
