% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{refactorNum}
\alias{refactorNum}
\title{Sort numeric factor levels by values}
\usage{
refactorNum(x, decreasing = FALSE)
}
\arguments{
\item{x}{A factor variable with numeric values as levels}

\item{decreasing}{Logical, should the levels sorted descendingly?}
}
\value{
A factor variable, with sorted numeric values as levels
}
\description{
Factor variables with numbers as levels are alphabetically ordered by
default, which requires rearrangements for various purposes, e.g. modelling
or visualizations. This function re-orders levels of numeric factor
variables numerically.
}
\examples{

(nums <- factor(c("2","4","24","1","2","125","1","2","125")))
(nums.new <- refactorNum(nums))

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
