% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pScore.R
\name{pQnormScore}
\alias{pQnormScore}
\title{Transform p-values to continuous scores with the quantile function of the normal distribution}
\usage{
pQnormScore(p, sign = 1)
}
\arguments{
\item{p}{\emph{p}-value(s) between \eqn{(0,1]}}

\item{sign}{Signs of the scores, either positive (in case of positive numbers),
negative (in case of negative numbers), or zero. In case of a logical vector,
\code{TRUE} is interpreted as positive and \code{FALSE} is interpreted as negative.}
}
\description{
Quantile function, also known as the inverse of cumulative distribution function of the normal 
distribution, is used to map p-values to continuous scores raging on \eqn{R}. The signs of the 
resulting scores are positive by default and are determined by the parameter \code{sign}.
}
\examples{
testPvals <- c(0.001, 0.01, 0.05, 0.1, 0.5, 1)
pQnormScore(testPvals)
testPvalSign <- rep(c(-1,1), 3)
pQnormScore(testPvals, sign=testPvalSign)
testLog <- rep(c(TRUE, FALSE),3)
pQnormScore(testPvals, testLog)

}
\seealso{
\code{\link{pAbsLog10Score}}, \code{pScore}
}
