% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiPersonIBD.R
\name{multiPersonIBD}
\alias{multiPersonIBD}
\title{Multi-person IBD coefficients}
\usage{
multiPersonIBD(x, ids, complete = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{ids}{A vector of ID labels.}

\item{complete}{A logical. If FALSE, only IBD patterns with nonzero
probability are included in the output.}

\item{verbose}{A logical. If TRUE, some computational details are printed.}
}
\value{
A data frame in which each row corresponds to an equivalence class of
multi-person IBD patterns. The first column gives the calculated
probability, followed by one column for each \code{ids} individual, describing
the minimal element of the equivalence class. (See Details.) If \code{complete = FALSE} (the default) rows with probability 0 are removed.
}
\description{
Computes the probabilities (coefficients) of all possible patterns of
identity by descent (IBD) sharing at a single locus, among N>1 non-inbred
members of a pedigree. The reported coefficients are "condensed" in the sense
that allele ordering within each individual is ignored. For N = 2, the result
should agree with the traditional "kappa" coefficients, as computed by
\code{\link[=kappaIBD]{kappaIBD()}}. This function is under development, and should be regarded as
experimental. For now, the only cases handled are those with: N = 2 or 3,
autosomal locus.
}
\details{
Consider N members of a pedigree, i1, i2, ... iN.  A pattern of IBD sharing
between these individuals is a sequence of N ordered pairs of labels, (a1_1,
a1_2), (a2_1, a2_2), ... (aN_1, aN_2), where ai_1 and ai_2 represent the
paternal and maternal allele of individual i, respectively. Equality of
labels means that the corresponding alleles are IBD, and vice versa.

We say that two IBD patterns are equivalent if one can be transformed into
the other by some combination of
\itemize{
\item renaming the labels (without changing the structure)
\item swapping the paternal/maternal labels of some individuals
}

Each equivalence class has a "minimal" element, using integer labels, and
being minimal with respect to standard sorting. For example, the minimal
element equivalent to \code{(a,c),(d,c),(b,b)} is \code{(1,2),(2,3),(4,4)}.
}
\examples{
### Trivial example: Trio ###
x = nuclearPed(1)
ids = 1:3
multiPersonIBD(x, ids, complete = TRUE)

### Example due to Peter Green ###
# Three (pariwise) cousins arranged in two different ways,
# with different 3-way IBD coefficients.

threeCousins1 = ped(
  id  = c('gf','gm','gf1','gf2','gf3','gm1','gm2','gm3',
          'f1','f2','f3','m1','m2','m3','c1','c2','c3'),
  fid = c(0,0,0,0,0,0,0,0,'gf1','gf2','gf3','gf','gf','gf',
          'f1','f2','f3'),
  mid = c(0,0,0,0,0,0,0,0,'gm1','gm2','gm3','gm','gm','gm',
          'm1','m2','m3'),
  sex = c(1,2,1,1,1,2,2,2,1,1,1,2,2,2,1,1,1))

threeCousins2 = ped(
  id  = c('gf1','gf2','gf3','gm1','gm2','gm3','f1','f2','f3',
          'm1','m2','m3','c1','c2','c3'),
  fid = c(0,0,0,0,0,0,'gf2','gf3','gf1','gf3','gf1','gf2',
          'f1','f2','f3'),
  mid = c(0,0,0,0,0,0,'gm2','gm3','gm1','gm3','gm1','gm2',
          'm1','m2','m3'),
  sex = c(1,1,1,2,2,2,1,1,1,2,2,2,1,1,1))

ids = c('c1','c2','c3')
multiPersonIBD(threeCousins1, ids)
multiPersonIBD(threeCousins2, ids)

}
