\name{gx.triples.aov}
\alias{gx.triples.aov}
\title{ Carries out a 3-Level Staggered ANOVA and Estimates Variance Components }
\description{
Function to undertake an ANOVA for the unbalanced triplicates from a GSC NGR or Tri-National survey.  The data must be in the following order for each triplicate: Analytical Duplicate, Field Duplicate for the Analytical Duplicate Split, other Field Duplicate.  The results replicate those generated by the UANOVA (Garrett and Goss, 1980) computer program.  Optionally the data may be logarithmically (base 10) transformed.
}
\usage{
gx.triples.aov(x, xname = deparse(substitute(x)), log = FALSE,
	table = FALSE)
}
\arguments{
  \item{x}{ a file of triplicate determinations, the order is critical, see Details below. }
  \item{xname}{ an informative description of the variable, \code{x}, in the data file for a table heading, for example, \cr\code{xname = "Ba (mg/kg - Aqua Regia digestion) in <2 mm unmilled C-horizon soil"}.  The default is simply the data file name, \code{xname = deparse(substitute(x))}. }
  \item{log}{ if a logarithmic transformation of the data is required to meet homogeneity of variance considerations (i.e. severe heteroscedasticity) set \code{log = TRUE}. This is also advisable if the range of the observations exceeds 1.5 orders of magnitude. }
  \item{table}{ set \code{table = TRUE} if the input data file is to be displayed. the default is no display. }
}
\details{
As noted above, the order of the data is critical and must be as follows for each triplicate: Analytical Duplicate, Field Duplicate for the Analytical Duplicate Split, other Field Duplicate.  The 'other Field Duplicate' is equivalent to a regular regional-coverage sample, but is at a 'Field Duplicate' site.  Thus below, x[i,1] will contain the Analytical Duplicates, x[i,2] the Field Duplicates from which the Analytical Duplicates were split, and x[i,3] the other analytically unduplicated Field Duplicates.  See Details in \code{\link{triples.test1}} for additional information. }
\note{
Any less than detection limit values represented by negative values, or zeros or other numeric codes representing blanks in the data, must be removed prior to executing this function, see \code{\link{ltdl.fix.df}}.

Any \code{NA}s in the data must also be removed prior to running the \code{triples.aov} function.  This requires care as the data must be in complete triplicate sets.
}
\references{
Bainbridge, T.R., 1963.  Staggered, nested designs for estimating variance components. American Society for Quality Control, Convention Transactions, pp. 93-103.

Garrett, R.G., in press.  Assessment of local spatial and analytical variability in regional geochemical surveys with a simple sampling scheme.  Geochemistry: Exploration, Environment, Analysis.

Garrett, R.G. & Goss, T.I., 1980.  UANOVA: A Fortran IV program for unbalanced nested anaylsis of variance.  Mathematical Geology, 6(1):35-60.

Satterthwaite, F.E., 1946.  An approximate distribution of estimates of variance components.  Biometrics, 2(2):110-114.

Snee, R.D., 1974.  Computation and use of expected mean squares in Analysis of Variance.  Journal of Quality Technology, 6(3):128-137. 
 
}
\author{ Robert G. Garrett }
\seealso{ \code{\link{ltdl.fix.df}}, \code{\link{remove.na}}, \code{\link{triples.test1}}, \code{\link{gx.triples.fgx}}, \code{\link{triples.test2}} }
\examples{
## Make test data available
data(triples.test1)
attach(triples.test1)

## Carry out unbalanced ANOVA
gx.triples.aov(Ba_ppm, xname = 
"Ba (mg/kg - Aqua Regia digestion) in <2 mm unmilled C-horizon soil")

## Detach test data
detach(triples.test1)
}
\keyword{ univar }
\keyword{ htest }
