gx.lm.vif <-
function(object, ...)
{
     # Function to compute Variance Inflation Factors (VIFs) from the
     # object generated by the function lm.  The VIF is a measure of
     # collinearity in the independent, predictor, variables.  VIFs >5
     # are indicative of collinearity, and the information conveyed in
     # that variable is also in the subset of the remaining variables.
     # A function offered on S-News by W.N. Venables, October 21, 2002.
     #
     V <- summary(object)$cov.unscaled
     Vi <- crossprod(model.matrix(object))
     nam <- names(coef(object))
     if(k <- match("(Intercept)", nam, nomatch = FALSE)) {
         v1 <- diag(V)[ - k]
         v2 <- (diag(Vi)[ - k] - Vi[k,  - k]^2/Vi[k, k])
         nam <- nam[ - k]
     }
     else {
         v1 <- diag(V)
         v2 <- diag(Vi)
         warning(" No intercept term detected - Results may surprise.")
     }
     structure(v1 * v2, names = nam)
}

