% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.new.R
\name{rgl.new}
\alias{rgl.new}
\title{Open and initialize new 3D plot}
\usage{
rgl.new(
  width = 0.5,
  aspect = 16/9,
  orientation = "xy",
  fov = 30,
  col = "white",
  light = TRUE,
  xlim = c(0, 1),
  ylim = c(0, 1),
  zlim = c(0, 1),
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  axes = FALSE,
  fixed = TRUE,
  close.all = TRUE,
  ...
)
}
\arguments{
\item{width}{either an integer (>1) specifying the number of pixels in the horizontal direction, or a real value (>0 and <=1) specifying the fraction of the available pixels. If the selected aspect ratio causes the number of vertical pixels to exceed the available number, the width is reduced as much as necessary.}

\item{aspect}{aspect ratio of window, defined as the ratio of vertical-to-horizontal size.}

\item{orientation}{3-by-3 rotation matrix or 2-character string specifying the orientation of the camera. For character string the allowed values are `xy`, `yx`, `yz`, `zy`, `zx`, `xz`, where the  first letter is the axis displayed from left to right and the second letter is the axis displayed from bottom to top. The third axis points either out of the screen or into the screen following the right-hand convention. This is the same as the \code{plane} argument of \code{\link{rgl.orthoview}}.}

\item{fov}{field of view in degrees, as used in \code{\link[rgl]{rgl.viewpoint}}}

\item{col}{background color}

\item{light}{logical flag. If \code{TRUE}, the standard light source created by \code{\link[rgl]{open3d}} will be light up the scene. If \code{FALSE}, no light source is added and the user must create custom light sources manually by calling \code{\link[rgl]{light3d}} or \code{\link[rgl]{rgl.light}}.}

\item{xlim}{2-vector specifying the range along the x-axis}

\item{ylim}{2-vector specifying the range along the y-axis}

\item{zlim}{2-vector specifying the range along the z-axis}

\item{xlab}{character string specifying the label of the x-axis}

\item{ylab}{character string specifying the label of the y-axis}

\item{zlab}{character string specifying the label of the z-axis}

\item{axes}{logical flag specifying whether axes are displayed}

\item{fixed}{logical flag. If \code{TRUE} (default), the range of the axes is *not* adjusted as objects are drawn.}

\item{close.all}{logical flag. If \code{TRUE} (default), all existing rgl windows are closed before the new window is opened.}

\item{...}{additional arguments for \code{\link[rgl]{rgl.viewpoint}}.}
}
\value{
None
}
\description{
Calls \code{\link[rgl]{open3d}} and various additional functions to initialize a 3d plot.
}
\author{
Danail Obreschkow
}
