% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa_clusters}
\alias{lisa_clusters}
\title{Get local cluster indicators}
\usage{
lisa_clusters(gda_lisa, cutoff = 0)
}
\arguments{
\item{gda_lisa}{An instance of LISA object}

\item{cutoff}{A value of cutoff for significance p-values to filter not-significant clusters, default=0.0, means not used}
}
\value{
A numeric vector of LISA cluster indicator
}
\description{
Get the local cluster indicators returned from LISA computation.
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
lisa <- local_moran(queen_w, crm_prs)
clsts <- lisa_clusters(lisa)
clsts
}
}
