% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa_values}
\alias{lisa_values}
\title{Get LISA values}
\usage{
lisa_values(gda_lisa)
}
\arguments{
\item{gda_lisa}{An instance of LISA object}
}
\value{
A numeric vector of local spatial autocorrelation
}
\description{
Get the local spatial autocorrelation values returned from LISA computation
}
\examples{
\dontrun{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
lisa <- local_moran(queen_w, crm_prs)
lms <- lisa_values(lisa)
lms
}
}
