% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hinge15_breaks}
\alias{hinge15_breaks}
\title{(Box) Hinge15 Breaks}
\usage{
hinge15_breaks(data)
}
\arguments{
\item{data}{A vector of numeric values}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Hinge15 breaks data into 6 groups like box plot groups (Lower outlier, < 25%, 25-50%, 50-75%, >75%, Upper outlier) with hinge=1.5
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
hinge15_breaks(data=crm_prs)
}
