% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-upload.R
\name{ee_utils_create_manifest_image}
\alias{ee_utils_create_manifest_image}
\title{Create a manifest to upload an image}
\usage{
ee_utils_create_manifest_image(
  gs_uri,
  assetId,
  properties = NULL,
  start_time = "1970-01-01",
  end_time = "1970-01-01",
  pyramiding_policy = "MEAN",
  returnList = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{gs_uri}{Character. GCS full path of the image to upload to Earth Engine assets
e.g. gs://rgee_dev/l8.tif}

\item{assetId}{Character. How to call the file once uploaded
to the Earth Engine Asset. e.g. users/datacolecfbf/l8.}

\item{properties}{List. Set of parameters to be set up as properties
of the EE object.}

\item{start_time}{Character. Sets the start time property (system:time_start)
It could be a number (timestamp) or a date.}

\item{end_time}{Character. Sets the end time property (system:time_end)
It could be a number (timestamp) or a date.}

\item{pyramiding_policy}{Character. The pyramid reduction policy to use.}

\item{returnList}{Logical. If TRUE will return the "manifest" as a list otherwise
will return a JSON file.}

\item{quiet}{Logical. Suppress info message.}
}
\value{
If \code{returnList} is TRUE a list otherwise a JSON file.
}
\description{
Create a manifest to upload a GeoTIFF to Earth Engine assets folder. The
"manifest" is simply a JSON file which describe all the upload parameters. See
\url{https://developers.google.com/earth-engine/guides/image_manifest} to get more
details.
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

tif <- system.file("tif/L7_ETMs.tif", package = "stars")

# Return a JSON file
ee_utils_create_manifest_image(
  gs_uri = "gs://rgee_dev/l8.tif",
  assetId = "users/datacolecfbf/l8"
)

# Return a list
ee_utils_create_manifest_image(
  gs_uri = "gs://rgee_dev/l8.tif",
  assetId = "users/datacolecfbf/l8",
  returnList = TRUE
)
}
}
\seealso{
Other generic upload functions: 
\code{\link{ee_utils_create_manifest_table}()},
\code{\link{local_to_gcs}()}
}
\concept{generic upload functions}
