% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-ml.data.frame.R
\docType{methods}
\name{[,ml.data.frame-method}
\alias{[,ml.data.frame-method}
\title{Extract subsets of a ml.data.frame}
\usage{
\S4method{[}{ml.data.frame}(x, i, j, ..., drop = NA)
}
\arguments{
\item{x}{a ml.data.frame from which to extract element(s).}

\item{i, j}{Indices specifying elements to extract. Indices are 'numeric' or 'character' vectors or empty (missing) or 'NULL'.}

\item{...}{Not used.}

\item{drop}{Not used.}
}
\value{
A ml.data.frame object is returned
}
\description{
Extract subset of columns and/or rows of a ml.data.frame. When extracting rows a ml.col.def
referense can be used or a search text, see \link{ml.data.frame} for query string grammar.
See details for limitations when using a reference.
The row filtering will be used togheter with the existing query of the ml.data.frame
}
\details{
When extracting rows using ml.col.def comparison operators can be used. For
the ">"  "<"  "!=" "<=" ">=" operators there muset exist a
\href{http://docs.marklogic.com/guide/admin/range_index#id_93351}{element range index}
on the source field or a error will be raised, element range index can be created using the \link{ml.add.index}
function. "==" operator will always work since it does not depend of range indexes.
}
\examples{
\dontrun{
 library(rfml)
 localConn <- ml.connect()
 # create a ml.data.frame based on the iris data set
 mlIris <- as.ml.data.frame(localConn, iris, "iris")
 # select first three columns
 mlIris2 <- mlIris[1:3]
 # same
 mlIris2 <- mlIris[,1:3]
 # same
 mlIris2 <- mlIris[,c("Sepal.Length","Sepal.Width","Petal.Length")]
 # select first three columns for all rows with Spieces = setosa
 mlIris2 <- mlIris[mlIris$Species=="setosa", 1:3]
 # select all columns for all rows with Spieces = setosa
 mlIris2 <- mlIris[mlIris$Species=="setosa",]
 # select all columns for all rows with "setosa" in any column
 mlIris2 <- mlIris["setosa",]
}
}
\concept{
array
}

