% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_terrain.R
\name{flsgen_terrain}
\alias{flsgen_terrain}
\title{Fractal terrain generator}
\usage{
flsgen_terrain(
  width,
  height,
  roughness = 0.5,
  x = 0,
  y = 0,
  resolution = 1e-04,
  epsg = "EPSG:4326"
)
}
\arguments{
\item{width}{Width (in pixels) of output raster}

\item{height}{Height (in pixels) of output raster}

\item{roughness}{Roughness factor (or H), between 0 and 1}

\item{x}{X position (geographical coordinates) of the top-left output raster pixel}

\item{y}{Y position (geographical coordinates) of the top-left output raster pixel}

\item{resolution}{Spatial resolution (geographical units) of the output raster (i.e. pixel dimension)}

\item{epsg}{EPSG identifier of the output projection}
}
\value{
A terra::rast object
}
\description{
Fractal terrain generation with the diamond-square algorithm
}
\examples{
  \dontrun{
    terrain <- flsgen_terrain(200, 200)
  }

}
