/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.min_max;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropMax
extends Propagator<IntVar> {
    private final int n;

    public PropMax(IntVar[] variables, IntVar maxVar) {
        super((Variable[])ArrayUtils.concat(variables, maxVar), (Priority)PropagatorPriority.LINEAR, false);
        this.n = variables.length;
        assert (this.n > 0);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean filter;
        do {
            filter = false;
            int lb = Integer.MIN_VALUE;
            int ub = Integer.MIN_VALUE;
            int max = ((IntVar[])this.vars)[this.n].getUB();
            for (int i = 0; i < this.n; ++i) {
                filter |= ((IntVar[])this.vars)[i].updateUpperBound(max, (ICause)this);
                lb = Math.max(lb, ((IntVar[])this.vars)[i].getLB());
                ub = Math.max(ub, ((IntVar[])this.vars)[i].getUB());
            }
            filter |= ((IntVar[])this.vars)[this.n].updateLowerBound(lb, (ICause)this);
            filter |= ((IntVar[])this.vars)[this.n].updateUpperBound(ub, (ICause)this);
            lb = Math.max(lb, ((IntVar[])this.vars)[this.n].getLB());
            int c = 0;
            int idx = -1;
            for (int i = 0; i < this.n; ++i) {
                if (((IntVar[])this.vars)[i].getUB() < lb) {
                    ++c;
                    continue;
                }
                idx = i;
            }
            if (c != ((IntVar[])this.vars).length - 2) continue;
            filter = false;
            ((IntVar[])this.vars)[idx].updateBounds(((IntVar[])this.vars)[this.n].getLB(), ((IntVar[])this.vars)[this.n].getUB(), this);
            if (((IntVar[])this.vars)[this.n].isInstantiated()) {
                this.setPassive();
                continue;
            }
            if (!((IntVar[])this.vars)[idx].hasEnumeratedDomain()) continue;
            while (((IntVar[])this.vars)[this.n].getLB() != ((IntVar[])this.vars)[idx].getLB() || ((IntVar[])this.vars)[this.n].getUB() != ((IntVar[])this.vars)[idx].getUB()) {
                ((IntVar[])this.vars)[this.n].updateBounds(((IntVar[])this.vars)[idx].getLB(), ((IntVar[])this.vars)[idx].getUB(), this);
                ((IntVar[])this.vars)[idx].updateBounds(((IntVar[])this.vars)[this.n].getLB(), ((IntVar[])this.vars)[this.n].getUB(), this);
            }
        } while (filter);
    }

    @Override
    public ESat isEntailed() {
        int i;
        int ub = ((IntVar[])this.vars)[this.n].getUB();
        int maxUb = ((IntVar[])this.vars)[0].getUB();
        for (i = 0; i < this.n; ++i) {
            maxUb = Math.max(maxUb, ((IntVar[])this.vars)[i].getUB());
            if (((IntVar[])this.vars)[i].getLB() <= ub) continue;
            return ESat.FALSE;
        }
        if (maxUb < ((IntVar[])this.vars)[this.n].getLB()) {
            return ESat.FALSE;
        }
        for (i = 0; i < this.n; ++i) {
            if (((IntVar[])this.vars)[i].getUB() <= ub) continue;
            return ESat.UNDEFINED;
        }
        if (((IntVar[])this.vars)[this.n].isInstantiated()) {
            for (i = 0; i < this.n; ++i) {
                if (!((IntVar[])this.vars)[i].isInstantiatedTo(ub)) continue;
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        int mask = explanation.readMask(p);
        int m = explanation.readValue(p);
        if (pivot == ((IntVar[])this.vars)[this.n]) {
            if (IntEventType.isInclow(mask)) {
                ((IntVar[])this.vars)[this.n].intersectLit(m, 0x3FFFFFFF, explanation);
                for (int i = 0; i < this.n; ++i) {
                    if (explanation.readDom(((IntVar[])this.vars)[i]).min() != m) continue;
                    IntIterableRangeSet seti = explanation.universe();
                    seti.removeBetween(m, 0x3FFFFFFF);
                    ((IntVar[])this.vars)[i].unionLit(seti, explanation);
                }
            } else if (IntEventType.isDecupp(mask)) {
                ((IntVar[])this.vars)[this.n].intersectLit(-1073741823, m, explanation);
                for (int i = 0; i < this.n; ++i) {
                    if (explanation.readDom(((IntVar[])this.vars)[i]).max() != m) continue;
                    IntIterableRangeSet seti = explanation.universe();
                    seti.removeBetween(-1073741823, m);
                    ((IntVar[])this.vars)[i].unionLit(seti, explanation);
                }
            }
        } else if (IntEventType.isInclow(mask)) {
            ((IntVar[])this.vars)[this.n].unionLit(-1073741823, m - 1, explanation);
            pivot.intersectLit(m, 0x3FFFFFFF, explanation);
        } else if (IntEventType.isDecupp(mask)) {
            ((IntVar[])this.vars)[this.n].unionLit(m + 1, 0x3FFFFFFF, explanation);
            pivot.intersectLit(-1073741823, m, explanation);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((IntVar[])this.vars)[this.n]).append(" = max(");
        sb.append(((IntVar[])this.vars)[0]);
        for (int i = 1; i < this.n; ++i) {
            sb.append(", ");
            sb.append(((IntVar[])this.vars)[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

