% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cargo_metadata.R
\name{read_cargo_metadata}
\alias{read_cargo_metadata}
\title{Retrieve metadata for packages and workspaces}
\usage{
read_cargo_metadata(path = ".", dependencies = FALSE, echo = FALSE)
}
\arguments{
\item{path}{character scalar, the R package directory}

\item{dependencies}{Default \code{FALSE}. A logical scalar, whether to include
all recursive dependencies in stdout.}

\item{echo}{Default \code{FALSE}. A logical scalar, should cargo command and
outputs be printed to the console.}
}
\value{
A \code{list} including the following elements:
\itemize{
\item \code{packages}
\item \code{workspace_members}
\item \code{workspace_default_members}
\item \code{resolve}
\item \code{target_directory}
\item \code{version}
\item \code{workspace_root}
\item \code{metadata}
}
}
\description{
Retrieve metadata for packages and workspaces
}
\details{
For more details, see
\href{https://doc.rust-lang.org/cargo/commands/cargo-metadata.html}{Cargo docs}
for \code{cargo-metadata}. See especially "JSON Format" to get a sense of what you
can expect to find in the returned list.
}
\examples{
\dontrun{
read_cargo_metadata()
}

}
