% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/character_class.R
\name{character_class}
\alias{:}
\alias{any_of}
\alias{character_class}
\alias{except}
\alias{except_any_of}
\alias{except_some_of}
\alias{exclude_range}
\alias{none_of}
\alias{one_of}
\alias{range}
\alias{some_of}
\title{Create character classes}
\usage{
character_class(x)

one_of(...)

any_of(..., type = c("greedy", "lazy", "possessive"))

some_of(..., type = c("greedy", "lazy", "possessive"))

none_of(...)

except_any_of(..., type = c("greedy", "lazy", "possessive"))

except_some_of(..., type = c("greedy", "lazy", "possessive"))

range(start, end)

":"(start, end)

exclude_range(start, end)
}
\arguments{
\item{x}{text to include in the character class (must be escaped manually)}

\item{...}{\code{\link{shortcuts}}, R variables, text, or other \pkg{rex}
functions.}

\item{type}{the type of match to perform.

There are three match types
\enumerate{
  \item \code{greedy}: match the longest string.  This is the default matching type.
  \item \code{lazy}: match the shortest string.  This matches the shortest string from the same anchor point, not necessarily the shortest global string.
  \item \code{possessive}: match and don't allow backtracking
}}

\item{start}{beginning of character class}

\item{end}{end of character class}
}
\description{
There are multiple ways you can define a character class.
}
\section{Functions}{
\itemize{
\item \code{character_class}: explicitly define a character class

\item \code{one_of}: matches one of the specified characters.

\item \code{any_of}: matches zero or more of the specified characters.

\item \code{some_of}: matches one or more of the specified characters.

\item \code{none_of}: matches anything but one of the specified characters.

\item \code{except_any_of}: matches zero or more of anything but the specified characters.

\item \code{except_some_of}: matches one or more of anything but the specified characters.

\item \code{range}: matches one of any of the characters in the range.

\item \code{:}: matches one of any of the characters in the range.

\item \code{exclude_range}: matches one of any of the characters except those in the range.
}}
\examples{
# grey = gray
re <- rex("gr", one_of("a", "e"), "y")
grepl(re, c("grey", "gray")) # TRUE TRUE

# Match non-vowels
re <- rex(none_of("a", "e", "i", "o", "u"))
# They can also be in the same string
re <- rex(none_of("aeiou"))
grepl(re, c("k", "l", "e")) # TRUE TRUE FALSE

# Match range
re <- rex(range("a", "e"))
grepl(re, c("b", "d", "f")) # TRUE TRUE FALSE

# Explicit creation
re <- rex(character_class("abcd\\\\["))
grepl(re, c("a", "d", "[", "]")) # TRUE TRUE TRUE FALSE
}
\seealso{
Other rex: \code{\link{.}}, \code{\link{capture}},
  \code{\link{capture_group}};
  \code{\link{\%if_next_is\%}},
  \code{\link{\%if_next_isnt\%}},
  \code{\link{\%if_prev_is\%}},
  \code{\link{\%if_prev_isnt\%}},
  \code{\link{lookarounds}}; \code{\link{\%or\%}},
  \code{\link{or}}; \code{\link{at_least}},
  \code{\link{at_most}}, \code{\link{between}},
  \code{\link{counts}}, \code{\link{n}},
  \code{\link{n_times}}; \code{\link{group}};
  \code{\link{maybe}}, \code{\link{one_or_more}},
  \code{\link{wildcards}}, \code{\link{zero_or_more}},
  \code{\link{zero_or_one}}; \code{\link{not}};
  \code{\link{rex}}, \code{\link{rex_}};
  \code{\link{shortcuts}}
}

