% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gp_beta}
\alias{gp_beta}
\title{Beta-type prior for GP shape parameter \eqn{\xi}}
\usage{
gp_beta(pars, min_xi = -1/2, max_xi = 1/2, pq = c(6, 9), trendsd = 0)
}
\arguments{
\item{pars}{A numeric vector of length 2.
GP parameters (\eqn{\sigma, \xi}).}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{pq}{A numeric vector of length 2.
See \code{\link{set_prior}} for details.}

\item{trendsd}{Has no function other than to achieve compatibility with
function in the evdbayes package.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
