% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gev_loglognorm}
\alias{gev_loglognorm}
\title{Trivariate normal prior for GEV parameters (\eqn{log \mu, log \sigma, \xi})}
\usage{
gev_loglognorm(pars, mean, icov, min_xi = -Inf, max_xi = Inf, trendsd = 0)
}
\arguments{
\item{pars}{A numeric vector of length 3.
GEV parameters (\eqn{\mu, \sigma, \xi}).}

\item{mean}{A numeric vector of length 3.  Prior mean.}

\item{icov}{A 3x3 numeric matrix.
The inverse of the prior covariance matrix.}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{trendsd}{Has no function other than to achieve compatability with
function in the evdbayes package.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
