% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revdbayes.R
\docType{package}
\name{revdbayes}
\alias{revdbayes}
\alias{revdbayes-package}
\title{revdbayes: Ratio-of-Uniforms Sampling for Bayesian Extreme Value Analysis}
\description{
Uses the multivariate generalized ratio-of-uniforms method to simulate
random samples from the posterior distributions commonly encountered in
Bayesian extreme value analyses.
}
\details{
The main function in the revbayes package is \code{rpost}, which
  simulates random samples from the posterior distribution of extreme value
  model parameters using the function \code{ru} from the rust package. The
  user chooses the extreme value model, the prior density for the parameters
  and provides the data.  There are options to improve the probability of
  acceptance of the ratio-of-uniforms algorithm by working with
  transformation of the model parameters.

  See \code{vignette("revdbayes-vignette", package = "revdbayes")} for an
  overview of the package.
}
\references{
Northrop, P. J. (2016). rust: Ratio-of-Uniforms Simulation with
  Transformation. R package version 1.1.0.
  \url{https://cran.r-project.org/package=rust}.
}
\seealso{
\code{\link{set_prior}} to set a prior density for extreme value
  parameters.

\code{\link{rpost}} to perform ratio-of-uniforms sampling from
  an extreme value posterior distribution.

The \code{\link[rust]{ru}} function in the \code{\link{rust}}
  package for details of the arguments that can be passed to \code{ru}
  via \code{rpost} and for the form of the object (of class "evprior")
  returned from \code{rpost}, which has the same structure as an object
  (of class "ru") returned by \code{ru}.
}
