% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eutil.R, R/ecitmatch.R, R/efetch.R, R/egquery.R, R/einfo.R, R/elink.R, R/epost.R, R/esearch.R, R/espell.R, R/esummary.R
\docType{methods}
\name{content}
\alias{content}
\alias{content,ecitmatch-method}
\alias{content,efetch-method}
\alias{content,egquery-method}
\alias{content,einfo-method}
\alias{content,elink-method}
\alias{content,epost-method}
\alias{content,esearch-method}
\alias{content,espell-method}
\alias{content,esummary-method}
\alias{content,eutil-method}
\title{Extract the data content from an Entrez request}
\usage{
content(x, ...)

\S4method{content}{eutil}(x, ...)

\S4method{content}{ecitmatch}(x, as = "text")

\S4method{content}{efetch}(x, as = NULL)

\S4method{content}{egquery}(x, as = NULL)

\S4method{content}{einfo}(x, as = NULL)

\S4method{content}{elink}(x, as = NULL)

\S4method{content}{epost}(x, as = NULL)

\S4method{content}{esearch}(x, as = NULL)

\S4method{content}{espell}(x, as = NULL)

\S4method{content}{esummary}(x, as = NULL)
}
\arguments{
\item{x}{An \code{\linkS4class{eutil}} object.}

\item{...}{Further arguments passed on to methods.}

\item{as}{Type of output: \code{"text"}, \code{"xml"}, \code{"json"},
\code{"textConnection"}, or \code{"parsed"}. \code{content} attempts to
figure out the most appropriate output type, based on the \code{retmode} of
the object.}
}
\description{
There are five ways to access data returned by an Entrez request: as a character
string \code{(as = "text")}, as a \code{\link{textConnection}}
\code{(as = "textConnection")}, as an \code{\linkS4class{XMLInternalDocument}}
\code{(as = "xml")} or \code{json} object \code{(as = "json")}
(depending on the \code{retmode} with which the request was performed),
or parsed into a native R object, e.g. a \code{list} or a \code{data.frame}
\code{(as = "parsed")}.
}
\section{Methods (by class)}{
\itemize{
\item \code{eutil}: Access the data content from an \code{eutil} object.

\item \code{ecitmatch}: Return PubMed IDs if \code{as = "parsed"}.

\item \code{efetch}: Access the data content from an \code{efetch} request.

\item \code{egquery}: Access the data content from an \code{egquery} request.

\item \code{einfo}: Access the data content from an \code{einfo} request.

\item \code{elink}: Access the data content from an \code{elink} request.

\item \code{epost}: Access the data content from an \code{epost} request.

\item \code{esearch}: Access the data content from an \code{esearch} request.

\item \code{espell}: Access the data content from an \code{espell} request.

\item \code{esummary}: Access the data content from an \code{esummary} request.
}}
\examples{
\dontrun{
## einfo() defaults to retmode 'xml'
e <- einfo()

## automatically return data as an 'XMLInternalDocument'.
if (e$no_errors()) {
  content(e)

  ## return the XML data as character string.
  cat(content(e, "text"))

  ## return DbNames parsed into a character vector.
  content(e, "parsed")
}

## return data as a JSON object
e2 <- einfo(db = "gene", retmode = "json")
if (e2$no_errors()) {
  content(e2)
}

## return a textConnection to allow linewise reading of the data.
x <- efetch("CP000828", "nuccore", rettype = "gbwithparts", retmode = "text")
con <- content(x, as = "textConnection")
readLines(con, 2)
close(con)
}
}
\seealso{
\code{\link{einfo}}, \code{\link{esearch}}, \code{\link{esummary}},
   \code{\link{efetch}}, \code{\link{elink}}, \code{\link{epost}},
   \code{\link{egquery}}, \code{\link{espell}}, \code{\link{ecitmatch}}.
}

