% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseSimulationOutput.R
\name{parseSimulationOutput}
\alias{parseSimulationOutput}
\title{Input data from CPP output into a list of data frames}
\usage{
parseSimulationOutput(filename)
}
\arguments{
\item{filename}{The filename of the output generated by the simulation}
}
\value{
A list containing
\describe{
\item{params}{the parameters used to run the simulation}
\item{sequences}{a data frame of the sequences over time and their similarity
to the initial sequence
\itemize{
\item step - timestep in the simulation
\item realTime - time since the start of the simulation (in millions of years)
\item sequenceId - the unique ID of the sequence (to track it over time);
  initial sequence has sequenceId 0 to (numInitialCopies-1)
\item parentMain - the unique ID of the sequence this burst from;
               (-1 if nothing)
\item parentOther - the unique ID of the sequence its parent recombined with;
                (-1 if nothing)
\item distanceToInitial - the distance to the initial sequence
\item isActive - whether or not the sequence is capable of transposition
}}
\item{pairwise}{a data frame of the pairwise similarity of sequences over time
\itemize{
\item step - timestep in the simulation
\item realTime - time since the start of the simulation (in millions of years)
\item sequenceId1 - an ID of a sequence present at the time
\item sequenceId2 - an ID of a different sequence present at the time; not all pairs
                are given - that is, for sequences a and b, either (a, b) or (b, a)
                is present as a row but not both
\item distancePairwise - the distance between the two sequences
}}
\item{familyRepresentatives}{a data frame of the family representatives
    for the retrotransposons over time
\itemize{
\item step - timestep in the simulation
\item realTime - time since the start of the simulation (in millions of years)
\item familyId - the unique ID of the family representative (to track it over time)
\item creationTime - time this family representative was created (in millions of years)
\item sequenceId - a sequence belonging to that family (sequences belonging to a
               family are listed as separate rows, and all sequences belonging
               to that family are listed)
}}
\item{familyPairwise}{a data frame of the pairwise similarity of the
    family representatives for the retrotransposons over time
\itemize{
\item step - timestep in the simulation
\item realTime - time since the start of the simulation (in millions of years)
\item familyId1 - an ID of a family representative present at the time
\item familyId2 - an ID of a different family representative present at the time;
              not all pairs are given - that is, for sequences a and b,
              either (a, b) or (b, a) is present as a row but not both
\item distancePairwise - the distance between the two family representatives
}}
}
}
\description{
Input data from CPP output into a list of data frames
}
\examples{
\dontrun{
data <- parseSimulationOutput('simulationOutput.out')
}
}
