% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheristruct.R
\name{flipped.triangles.cart}
\alias{flipped.triangles.cart}
\title{Determine indices of triangles that are flipped}
\usage{
flipped.triangles.cart(P, Tt, R)
}
\arguments{
\item{P}{Points in Cartesian coordinates}

\item{Tt}{Triangulation of points}

\item{R}{Radius of sphere}
}
\value{
List containing:
\item{\code{flipped}}{Indices of in rows of \code{Tt} of flipped triangles.}
\item{\code{cents}}{Vectors of centres.}
\item{\code{areas}}{Areas of triangles.}
}
\description{
In the projection of points onto the sphere, some triangles maybe
flipped, i.e. in the wrong orientation.  This functions determines
which triangles are flipped by computing the vector pointing to
the centre of each triangle and comparing this direction to vector
product of two sides of the triangle.
}
\author{
David Sterratt
}
