/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Arrays;
import java.util.Iterator;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.LitVar;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

@Explained
public final class IntVarEagerLit
extends AbstractVariable
implements IntVar,
LitVar {
    final IntVar var;
    final MiniSat sat;
    boolean channeling = true;
    final int[] values;
    final int lit_min;
    final int lit_max;
    final int base_vlit;
    final int base_blit;

    public IntVarEagerLit(IntVar var) {
        super(var.getName(), var.getModel());
        this.model.unassociates(var);
        this.var = var;
        if (!var.hasEnumeratedDomain()) {
            throw new UnsupportedOperationException("IntVarEagerLit can only wrap enumerated integer variables");
        }
        this.sat = this.getModel().getSolver().getSat();
        this.lit_min = var.getLB();
        this.lit_max = var.getUB();
        int capacity = this.lit_max - this.lit_min + 1;
        if (capacity > 30 && (this.lit_max - this.lit_min) / var.getDomainSize() > 5) {
            this.values = var.stream().toArray();
            this.base_vlit = 2 * this.sat.nVars();
            this.base_blit = 2 * (this.sat.nVars() + this.values.length) + 1;
            this.initSparseDomain();
        } else {
            this.values = null;
            this.base_vlit = 2 * (this.sat.nVars() - this.lit_min);
            this.base_blit = 2 * (this.sat.nVars() + capacity - this.lit_min) + 1;
            this.initDenseDomain();
        }
    }

    private void initDenseDomain() {
        int i;
        int v;
        for (v = this.lit_min; v <= this.lit_max; ++v) {
            this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 0, v));
            if (this.var.contains(v)) continue;
            this.sat.cEnqueue(this.getNELit(v), Reason.undef());
        }
        if (this.var.isInstantiated()) {
            this.sat.cEnqueue(this.getEQLit(this.lit_min), Reason.undef());
        }
        for (v = this.lit_min - 1; v <= this.lit_max; ++v) {
            this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 1, v));
        }
        for (i = this.lit_min; i <= this.lit_min; ++i) {
            this.sat.cEnqueue(this.getGELit(i), Reason.undef());
        }
        for (i = this.lit_max; i <= this.lit_max; ++i) {
            this.sat.cEnqueue(this.getLELit(i), Reason.undef());
        }
    }

    private void initSparseDomain() {
        assert (!this.var.isInstantiated()) : "IntVarEagerLit should not wrap an instantiated variable";
        for (int v : this.values) {
            this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 0, v));
        }
        this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 1, this.lit_min - 1));
        for (int v : this.values) {
            this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 1, v));
        }
    }

    @Override
    public void channel(int val, int val_type, int sign) {
        block8: {
            this.channeling = false;
            int op = val_type * 3 ^ sign;
            try {
                switch (op) {
                    case 0: {
                        this.removeValue(val, Cause.Null, Reason.undef());
                        break;
                    }
                    case 1: {
                        this.instantiateTo(val, Cause.Null, Reason.undef());
                        break;
                    }
                    case 2: {
                        this.updateLowerBound(val + 1, Cause.Null, Reason.undef());
                        break;
                    }
                    case 3: {
                        this.updateUpperBound(val, Cause.Null, Reason.undef());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("IntVarEagerLit#channel");
                    }
                }
            }
            catch (ContradictionException ce) {
                if ($assertionsDisabled || this.sat.confl != MiniSat.C_Undef) break block8;
                throw new AssertionError();
            }
        }
        this.channeling = true;
    }

    private int findIndex(int v, RoundMode type) {
        int l = 0;
        int u = this.values.length - 1;
        do {
            int m;
            if (this.values[m = (l + u) / 2] == v) {
                return m;
            }
            if (this.values[m] < v) {
                l = m + 1;
                continue;
            }
            u = m - 1;
        } while (u >= l);
        switch (type.ordinal()) {
            case 0: {
                return u;
            }
            case 1: {
                return l;
            }
        }
        return -1;
    }

    @Override
    public int getLit(int v, int t) {
        if (v < this.lit_min) {
            return 1 ^ t & 1;
        }
        if (v > this.lit_max) {
            return t - 1 >> 1 & 1;
        }
        switch (t) {
            case 0: {
                if (this.values == null) {
                    return this.base_vlit + 2 * v;
                }
                int u = this.findIndex(v, RoundMode.ROUND_NONE);
                return u == -1 ? 1 : this.base_vlit + 2 * u;
            }
            case 1: {
                if (this.values == null) {
                    return this.base_vlit + 2 * v + 1;
                }
                int u = this.findIndex(v, RoundMode.ROUND_NONE);
                return u == -1 ? 0 : this.base_vlit + 2 * u + 1;
            }
            case 2: {
                int u = this.values == null ? v : this.findIndex(v, RoundMode.ROUND_UP);
                return this.base_blit + 2 * u;
            }
            case 3: {
                int u = this.values == null ? v : this.findIndex(v, RoundMode.ROUND_DOWN);
                return this.base_blit + 2 * u + 1;
            }
        }
        throw new UnsupportedOperationException("IntVarEagerLit#getLit");
    }

    @Override
    public int getMinLit() {
        return MiniSat.neg(this.getGELit(this.getLB()));
    }

    @Override
    public int getMaxLit() {
        return MiniSat.neg(this.getLELit(this.getUB()));
    }

    @Override
    public int getValLit() {
        assert (this.isInstantiated()) : this.var + " is not instantiated";
        return this.getLit(this.getLB(), 0);
    }

    private void channelMin(int v) {
        Reason r = Reason.r(MiniSat.neg(this.getGELit(v)));
        int min = this.getLB();
        if (this.values == null) {
            for (int i = v - 1; i > min; --i) {
                this.sat.cEnqueue(this.getGELit(i), r);
                if (!this.var.contains(i)) continue;
                this.sat.cEnqueue(this.getNELit(i), r);
            }
        } else {
            int i = Arrays.binarySearch(this.values, v - 1);
            if (i < 0) {
                i = -i - 2;
            }
            while (i >= 0 && this.values[i] > min) {
                int u = this.values[i];
                this.sat.cEnqueue(this.getGELit(u), r);
                if (this.var.contains(u)) {
                    this.sat.cEnqueue(this.getNELit(u), r);
                }
                --i;
            }
        }
        this.sat.cEnqueue(this.getNELit(min), r);
    }

    private void updateMin(int oldMin, int newMin) {
        if (this.values == null) {
            for (int v = oldMin; v < newMin; ++v) {
                Reason r = Reason.r(this.getLELit(v - 1), this.getEQLit(v));
                this.sat.cEnqueue(this.getGELit(v + 1), r);
            }
        } else {
            int u = this.findIndex(oldMin, RoundMode.ROUND_UP);
            int v = this.values[u];
            while (v < newMin) {
                Reason r = Reason.r(this.getLELit(v - 1), this.getEQLit(v));
                this.sat.cEnqueue(this.getGELit(v + 1), r);
                v = this.values[++u];
            }
        }
    }

    private void channelMax(int v) {
        Reason r = Reason.r(MiniSat.neg(this.getLELit(v)));
        int max = this.getUB();
        if (this.values == null) {
            for (int i = v + 1; i < max; ++i) {
                this.sat.cEnqueue(this.getLELit(i), r);
                if (!this.var.contains(i)) continue;
                this.sat.cEnqueue(this.getNELit(i), r);
            }
        } else {
            int i = Arrays.binarySearch(this.values, v + 1);
            if (i < 0) {
                i = -i - 1;
            }
            while (i < this.values.length && this.values[i] < max) {
                int u = this.values[i];
                this.sat.cEnqueue(this.getLELit(u), r);
                if (this.var.contains(u)) {
                    this.sat.cEnqueue(this.getNELit(u), r);
                }
                ++i;
            }
        }
        this.sat.cEnqueue(this.getNELit(max), r);
    }

    private void updateMax(int oldMax, int newMax) {
        if (this.values == null) {
            for (int v = oldMax; v > newMax; --v) {
                Reason r = Reason.r(this.getGELit(v + 1), this.getEQLit(v));
                this.sat.cEnqueue(this.getLELit(v - 1), r);
            }
        } else {
            int u = this.findIndex(oldMax, RoundMode.ROUND_DOWN);
            int v = this.values[u];
            while (v > newMax) {
                Reason r = Reason.r(this.getGELit(v + 1), this.getEQLit(v));
                this.sat.cEnqueue(this.getLELit(v - 1), r);
                v = this.values[--u];
            }
        }
    }

    private void channelFix(int v) {
        Reason r = Reason.r(this.getNELit(v));
        if (this.getLB() < v) {
            this.sat.cEnqueue(this.getGELit(v), r);
            this.channelMin(v);
        }
        if (this.getUB() > v) {
            this.sat.cEnqueue(this.getLELit(v), r);
            this.channelMax(v);
        }
    }

    private void updateFixed(int v) {
        Reason r = Reason.r(this.getLELit(v - 1), this.getGELit(v + 1));
        this.sat.cEnqueue(this.getEQLit(v), r);
    }

    @Override
    public boolean removeValue(int value, ICause cause, Reason reason) throws ContradictionException {
        if (this.contains(value)) {
            if (this.channeling) {
                this.notify(reason, cause, this.sat, this.getLit(value, 0));
            }
            if (this.isInstantiated()) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            IntEventType e = IntEventType.REMOVE;
            if (value == this.getLB()) {
                this.updateMin(value, this.var.nextValue(value));
                e = IntEventType.INCLOW;
            }
            if (value == this.getUB()) {
                this.updateMax(value, this.var.previousValue(value));
                e = IntEventType.DECUPP;
            }
            if (this.var.getDomainSize() == 2) {
                this.updateFixed(this.getLB() == value ? this.getUB() : this.getLB());
                e = IntEventType.INSTANTIATE;
            }
            this.var.removeValue(value, (ICause)Cause.Null);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause, Reason reason) throws ContradictionException {
        throw new UnsupportedOperationException("#removeValues");
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause, Reason reason) throws ContradictionException {
        throw new UnsupportedOperationException("#removeAllValuesBut");
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        throw new UnsupportedOperationException("#removeInterval");
    }

    @Override
    public boolean instantiateTo(int value, ICause cause, Reason reason) throws ContradictionException {
        if (!this.isInstantiatedTo(value)) {
            if (this.channeling) {
                this.notify(reason, cause, this.sat, this.getLit(value, 1));
            }
            if (!this.var.contains(value)) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            this.channelFix(value);
            this.var.instantiateTo(value, (ICause)Cause.Null);
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause, Reason reason) throws ContradictionException {
        if (value > this.getLB()) {
            if (this.channeling) {
                this.notify(reason, cause, this.sat, this.getLit(value, 2));
            }
            if (value > this.getUB()) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            this.channelMin(value);
            this.updateMin(value, this.var.nextValue(value - 1));
            int ub = this.getUB();
            IntEventType e = IntEventType.INCLOW;
            if (value == ub || this.var.nextValue(value - 1) == ub) {
                this.updateFixed(ub);
                e = IntEventType.INSTANTIATE;
            }
            this.var.updateLowerBound(value, (ICause)Cause.Null);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause, Reason reason) throws ContradictionException {
        if (value < this.getUB()) {
            if (this.channeling) {
                this.notify(reason, cause, this.sat, this.getLit(value, 3));
            }
            if (value < this.getLB()) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            this.channelMax(value);
            this.updateMax(value, this.var.previousValue(value + 1));
            int lb = this.getLB();
            IntEventType e = IntEventType.DECUPP;
            if (value == lb || this.var.previousValue(value + 1) == lb) {
                this.updateFixed(lb);
                e = IntEventType.INSTANTIATE;
            }
            this.var.updateUpperBound(value, (ICause)Cause.Null);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause, Reason reason) throws ContradictionException {
        throw new UnsupportedOperationException("#updateBounds");
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(value);
    }

    @Override
    public int getValue() throws IllegalStateException {
        return this.var.getValue();
    }

    @Override
    public int getLB() {
        return this.var.getLB();
    }

    @Override
    public int getUB() {
        return this.var.getUB();
    }

    @Override
    public int getRange() {
        return this.var.getRange();
    }

    @Override
    public int nextValue(int v) {
        return this.var.nextValue(v);
    }

    @Override
    public int nextValueOut(int v) {
        return this.var.nextValueOut(v);
    }

    @Override
    public int previousValue(int v) {
        return this.var.previousValue(v);
    }

    @Override
    public int previousValueOut(int v) {
        return this.var.previousValueOut(v);
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        return this.var.getValueIterator(bottomUp);
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        return this.var.getRangeIterator(bottomUp);
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.var.hasEnumeratedDomain();
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        return this.var.monitorDelta(propagator);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.var.iterator();
    }

    @Override
    public boolean isInstantiated() {
        return this.var.isInstantiated();
    }

    @Override
    public int getDomainSize() {
        return this.var.getDomainSize();
    }

    @Override
    public IDelta getDelta() {
        return this.var.getDelta();
    }

    @Override
    public void createDelta() {
        this.var.createDelta();
    }

    @Override
    public int getTypeAndKind() {
        return this.var == null ? 9 : this.var.getTypeAndKind();
    }

    protected EvtScheduler<IntEventType> createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public String toString() {
        return this.var.toString();
    }

    static enum RoundMode {
        ROUND_DOWN,
        ROUND_UP,
        ROUND_NONE;

    }
}

