/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.relational;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.arithmetic.IfArExpression;
import org.chocosolver.solver.expression.discrete.logical.BiLoExpression;
import org.chocosolver.solver.expression.discrete.logical.LoExpression;
import org.chocosolver.solver.expression.discrete.logical.NaLoExpression;
import org.chocosolver.solver.expression.discrete.logical.UnLoExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public interface ReExpression
extends ArExpression {
    @Override
    public Model getModel();

    public BoolVar boolVar();

    @Override
    default public IntVar intVar() {
        return this.boolVar();
    }

    @Override
    public void extractVar(HashSet<IntVar> var1);

    default public void post() {
        this.decompose().post();
    }

    default public Constraint decompose() {
        throw new UnsupportedOperationException();
    }

    default public Constraint extension() {
        LinkedHashSet<IntVar> avars = new LinkedHashSet<IntVar>();
        this.extractVar(avars);
        IntVar[] uvars = (IntVar[])avars.stream().sorted().toArray(IntVar[]::new);
        Map<IntVar, Integer> map = IntStream.range(0, uvars.length).boxed().collect(Collectors.toMap(i -> uvars[i], i -> i));
        Tuples tuples = TuplesFactory.generateTuples(values -> this.beval(values, map), true, uvars);
        return this.getModel().table(uvars, tuples);
    }

    default public boolean beval(int[] values, Map<IntVar, Integer> map) {
        if (!2.$assertionsDisabled && !(this instanceof BoolVar)) {
            throw new AssertionError();
        }
        return values[map.get(this)] == 1;
    }

    @Override
    default public int ieval(int[] values, Map<IntVar, Integer> map) {
        return this.beval(values, map) ? 1 : 0;
    }

    default public ReExpression and(ReExpression ... y) {
        return new NaLoExpression(LoExpression.Operator.AND, this, y);
    }

    default public ReExpression or(ReExpression ... y) {
        return new NaLoExpression(LoExpression.Operator.OR, this, y);
    }

    default public ReExpression xor(ReExpression ... y) {
        if (y.length == 1) {
            return new BiLoExpression(LoExpression.Operator.XOR, this, y[0]);
        }
        return new NaLoExpression(LoExpression.Operator.XOR, this, y);
    }

    default public ReExpression imp(ReExpression y) {
        return new BiLoExpression(LoExpression.Operator.IMP, this, y);
    }

    default public ReExpression iff(ReExpression ... y) {
        if (y.length == 1) {
            return new BiLoExpression(LoExpression.Operator.IFF, this, y[0]);
        }
        return new NaLoExpression(LoExpression.Operator.IFF, this, y);
    }

    default public ReExpression not() {
        return new UnLoExpression(LoExpression.Operator.NOT, this);
    }

    default public ArExpression ift(ArExpression y1, ArExpression y2) {
        return new IfArExpression(this, y1, y2);
    }

    default public ArExpression ift(ArExpression y1, int y2) {
        return new IfArExpression(this, y1, this.getModel().intVar(y2));
    }

    default public ArExpression ift(int y1, ArExpression y2) {
        return new IfArExpression(this, this.getModel().intVar(y1), y2);
    }

    default public ArExpression ift(int y1, int y2) {
        return new IfArExpression(this, this.getModel().intVar(y1), this.getModel().intVar(y2));
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum Operator {
        LT{

            @Override
            boolean eval(int i1, int i2) {
                return i1 < i2;
            }
        }
        ,
        LE{

            @Override
            boolean eval(int i1, int i2) {
                return i1 <= i2;
            }
        }
        ,
        GE{

            @Override
            boolean eval(int i1, int i2) {
                return i1 >= i2;
            }
        }
        ,
        GT{

            @Override
            boolean eval(int i1, int i2) {
                return i1 > i2;
            }
        }
        ,
        NE{

            @Override
            boolean eval(int i1, int i2) {
                return i1 != i2;
            }
        }
        ,
        EQ{

            @Override
            boolean eval(int i1, int i2) {
                return i1 == i2;
            }
        }
        ,
        IN{

            @Override
            boolean eval(int i1, int i2) {
                return i1 == i2;
            }
        };


        abstract boolean eval(int var1, int var2);
    }
}

