% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_min_nb_pus_objective.R
\name{set_min_nb_pus_objective}
\alias{set_min_nb_pus_objective}
\title{Set an objective to minimize the number of planning units}
\usage{
set_min_nb_pus_objective(problem)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Specify that a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) should
minimize the number of planning units.
}
\details{
Planning units correspond to aggregated cells from the original
dataset. Minimizing the number of planning units reduces the spatial extent
of the restoration area.
}
\examples{
\donttest{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

locked_out_data <- rast(
 system.file("extdata", "locked_out.tif", package = "restoptr")
)

# plot data
plot(rast(list(habitat_data, locked_out_data)), nc = 2)

# create problem with locked out constraints
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  set_min_nb_pus_objective() \%>\%
  add_restorable_constraint(
    min_restore = 5,
    max_restore = 5,
  ) \%>\%
  add_locked_out_constraint(data = locked_out_data) \%>\%
  add_settings(time_limit = 1)

# print problem
print(p)

# solve problem
s <- solve(p)

# plot solution
plot(s)
}

}
\seealso{
Other objectives: 
\code{\link{set_max_iic_objective}()},
\code{\link{set_max_mesh_objective}()},
\code{\link{set_max_nb_pus_objective}()},
\code{\link{set_max_restore_objective}()},
\code{\link{set_min_restore_objective}()},
\code{\link{set_no_objective}()}
}
\concept{objectives}
