/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.tree;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.AlphaDominatorsFinder;
import org.chocosolver.util.graphOperations.dominance.SimpleDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PropAntiArborescences
extends Propagator<IntVar> {
    private final DirectedGraph connectedGraph;
    private final int n;
    private final AbstractLengauerTarjanDominatorsFinder domFinder;
    private final int offSet;

    public PropAntiArborescences(IntVar[] succs, int offSet, boolean linear) {
        super((Variable[])succs, (Priority)PropagatorPriority.LINEAR, false);
        this.n = succs.length;
        this.offSet = offSet;
        this.connectedGraph = new DirectedGraph(this.n + 1, SetType.BITSET, false);
        this.domFinder = linear ? new AlphaDominatorsFinder(this.n, this.connectedGraph) : new SimpleDominatorsFinder(this.n, this.connectedGraph);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (int i = 0; i < this.n; ++i) {
                ((IntVar[])this.vars)[i].updateBounds(this.offSet, this.n - 1 + this.offSet, this);
            }
        }
        this.structuralPruning();
    }

    private void structuralPruning() throws ContradictionException {
        int y;
        int ub;
        int i;
        for (i = 0; i < this.n + 1; ++i) {
            this.connectedGraph.getSuccessorsOf(i).clear();
            this.connectedGraph.getPredecessorsOf(i).clear();
        }
        for (i = 0; i < this.n; ++i) {
            ub = ((IntVar[])this.vars)[i].getUB();
            y = ((IntVar[])this.vars)[i].getLB();
            while (y <= ub) {
                if (i == y) {
                    this.connectedGraph.addEdge(i, this.n);
                } else {
                    this.connectedGraph.addEdge(i, y - this.offSet);
                }
                y = ((IntVar[])this.vars)[i].nextValue(y);
            }
        }
        if (this.domFinder.findPostDominators()) {
            for (int x = 0; x < this.n; ++x) {
                ub = ((IntVar[])this.vars)[x].getUB();
                y = ((IntVar[])this.vars)[x].getLB();
                while (y <= ub) {
                    if (x != y && this.domFinder.isDomminatedBy(y - this.offSet, x)) {
                        ((IntVar[])this.vars)[x].removeValue(y, this);
                    }
                    y = ((IntVar[])this.vars)[x].nextValue(y);
                }
            }
        } else {
            this.fails();
        }
    }

    @Override
    public ESat isEntailed() {
        if (!this.isCompletelyInstantiated()) {
            return ESat.UNDEFINED;
        }
        ISet tmp = SetFactory.makeBitSet(0);
        for (int i = 0; i < this.n; ++i) {
            if (!this.circuit(tmp, i)) continue;
            return ESat.FALSE;
        }
        return ESat.TRUE;
    }

    private boolean circuit(ISet tmp, int i) {
        tmp.clear();
        int x = i;
        tmp.add(x);
        int y = ((IntVar[])this.vars)[x].getValue() - this.offSet;
        while (x != y) {
            x = y;
            if (tmp.contains(x)) {
                return true;
            }
            tmp.add(x);
            y = ((IntVar[])this.vars)[x].getValue() - this.offSet;
        }
        return false;
    }
}

