/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sort;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;
import org.chocosolver.util.tools.ArrayUtils;

public final class PropKeysorting
extends Propagator<IntVar> {
    private final int n;
    private final int m;
    private int k;
    private final IntVar[][] X;
    private final IntVar[][] Y;
    private int[][] XLB;
    private int[][] XUB;
    private final int[][] YLB;
    private final int[][] YUB;
    private final int[] CHUNK;
    private final int[] SORTMIN;
    private final int[] SORTMAX;
    private int[] XMATE;
    private final int[] YMATE;
    private final int[] NODE;
    private final int[] ROOT;
    private final int[] RIGHTMOST;
    private final int[] MAXX;
    private int[] SCC;
    private final int[] SORTY;
    private final int[] ARRAY;
    private final int[] CUR;
    private boolean prune;
    protected final ArraySort sorter;
    private final IntComparator sortmincomp1 = (i, j) -> {
        int z;
        for (z = 0; z <= this.k && this.XLB[i][z] == this.XLB[j][z]; ++z) {
        }
        return z <= this.k ? this.XLB[i][z] - this.XLB[j][z] : 0;
    };
    private final IntComparator sortmincomp2 = (i, j) -> {
        if (this.SCC[this.XMATE[i]] != this.SCC[this.XMATE[j]]) {
            return this.SCC[this.XMATE[i]] - this.SCC[this.XMATE[j]];
        }
        return 0;
    };
    private final IntComparator sortmaxcomp1 = (i, j) -> {
        int z;
        for (z = 0; z <= this.k && this.XUB[i][z] == this.XUB[j][z]; ++z) {
        }
        return z <= this.k ? this.XUB[i][z] - this.XUB[j][z] : 0;
    };
    private final IntComparator sortmaxcomp2 = (i, j) -> {
        if (this.SCC[this.XMATE[i]] != this.SCC[this.XMATE[j]]) {
            return this.SCC[this.XMATE[i]] - this.SCC[this.XMATE[j]];
        }
        return 0;
    };
    private final IntComparator sortycomp = (i, j) -> {
        if (this.SCC[i] != this.SCC[j]) {
            return this.SCC[i] - this.SCC[j];
        }
        return i - j;
    };

    public PropKeysorting(IntVar[][] x, IntVar[][] y, IntVar[] p, int key) {
        super((Variable[])ArrayUtils.append(ArrayUtils.flatten(x), ArrayUtils.flatten(y), p), (Priority)PropagatorPriority.LINEAR, false);
        this.n = x.length;
        this.m = x[0].length;
        this.k = key;
        this.X = new IntVar[this.n][this.m + 1];
        this.Y = new IntVar[this.n][this.m + 1];
        for (int i2 = 0; i2 < this.n; ++i2) {
            System.arraycopy(x[i2], 0, this.X[i2], 0, this.k);
            System.arraycopy(y[i2], 0, this.Y[i2], 0, this.k);
            this.X[i2][this.k] = this.model.intVar(i2 + 1);
            this.Y[i2][this.k] = p[i2];
            System.arraycopy(x[i2], this.k, this.X[i2], this.k + 1, this.m - this.k);
            System.arraycopy(y[i2], this.k, this.Y[i2], this.k + 1, this.m - this.k);
        }
        this.XLB = new int[this.n][this.k + 1];
        this.XUB = new int[this.n][this.k + 1];
        this.YLB = new int[this.n][this.k + 1];
        this.YUB = new int[this.n][this.k + 1];
        this.SORTMIN = new int[this.n];
        this.SORTMAX = new int[this.n];
        this.XMATE = new int[this.n];
        this.YMATE = new int[this.n];
        this.NODE = new int[this.n];
        this.ROOT = new int[this.n];
        this.RIGHTMOST = new int[this.n];
        this.MAXX = new int[this.n];
        this.SCC = new int[this.n];
        this.SORTY = new int[this.n];
        this.CHUNK = new int[this.n];
        this.ARRAY = new int[this.n];
        this.CUR = new int[this.k + 1];
        this.sorter = new ArraySort(this.n, false, true);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int j;
            IntVar[] ys = this.Y[0];
            for (int i = 1; i < this.n; ++i) {
                for (j = 0; j < this.k + 1; ++j) {
                    if (ys[j].getValue() == this.Y[i][j].getValue()) continue;
                    if (ys[j].getValue() < this.Y[i][j].getValue()) break;
                    return ESat.FALSE;
                }
                int p = ys[this.k].getValue() - 1;
                for (int j2 = 0; j2 <= this.m; ++j2) {
                    if (this.X[p][j2].getValue() == ys[j2].getValue()) continue;
                    return ESat.FALSE;
                }
                ys = this.Y[i];
            }
            int p = ys[this.k].getValue() - 1;
            for (j = 0; j <= this.m; ++j) {
                if (this.X[p][j].getValue() == ys[j].getValue()) continue;
                return ESat.FALSE;
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    private void filter() throws ContradictionException {
        do {
            this.prune = false;
            this.init();
            this.normalizeY();
            this.normalizeX();
            this.matchUp();
            this.matchDown();
            this.findSCC();
            this.narrow();
            this.prune();
        } while (this.prune);
    }

    private boolean init() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j <= this.k; ++j) {
                this.XLB[i][j] = this.X[i][j].getLB();
                this.XUB[i][j] = this.X[i][j].getUB();
                this.YLB[i][j] = this.Y[i][j].getLB();
                this.YUB[i][j] = this.Y[i][j].getUB();
                this.SORTMAX[i] = this.SORTY[i] = i;
                this.SORTMIN[i] = this.SORTY[i];
            }
        }
        return true;
    }

    private void normalizeY() throws ContradictionException {
        int i;
        System.arraycopy(this.YLB[0], 0, this.CUR, 0, this.k + 1);
        for (i = 1; i < this.n; ++i) {
            int n = this.k;
            this.CUR[n] = this.CUR[n] + 1;
            if (!this.lexFixMin(this.YLB[i], this.YUB[i], this.CUR)) {
                this.fails();
            }
            System.arraycopy(this.YLB[i], 0, this.CUR, 0, this.k + 1);
        }
        System.arraycopy(this.YUB[this.n - 1], 0, this.CUR, 0, this.k + 1);
        for (i = this.n - 2; i >= 0; --i) {
            int n = this.k;
            this.CUR[n] = this.CUR[n] - 1;
            if (!this.lexFixMax(this.YLB[i], this.YUB[i], this.CUR)) {
                this.fails();
            }
            System.arraycopy(this.YUB[i], 0, this.CUR, 0, this.k + 1);
        }
    }

    private void normalizeX() throws ContradictionException {
        int x;
        int i;
        this.sorter.sort(this.SORTMIN, this.n, this.sortmincomp1);
        int y = 0;
        for (i = 0; i < this.n; ++i) {
            x = this.SORTMIN[i];
            while (y < this.n && this.lexLt(this.YUB[y], this.XLB[x], this.k + 1)) {
                ++y;
            }
            if (y == this.n) {
                this.fails();
            }
            if (!this.lexLt(this.XLB[x], this.YLB[y], this.k + 1) || this.lexFixMin(this.XLB[x], this.XUB[x], this.YLB[y])) continue;
            this.fails();
        }
        this.sorter.sort(this.SORTMAX, this.n, this.sortmaxcomp1);
        y = this.n - 1;
        for (i = this.n - 1; i > 0; --i) {
            x = this.SORTMAX[i];
            while (y >= 0 && this.lexLt(this.XUB[x], this.YLB[y], this.k + 1)) {
                --y;
            }
            if (y < 0) {
                this.fails();
            }
            if (!this.lexLt(this.YUB[y], this.XUB[x], this.k + 1) || this.lexFixMax(this.XLB[x], this.XUB[x], this.YUB[y])) continue;
            this.fails();
        }
    }

    private void matchUp() throws ContradictionException {
        int y;
        int e = 0;
        int i = 0;
        int x = this.SORTMIN[i];
        for (y = 0; y < this.n; ++y) {
            while (i < this.n && !this.lexLt(this.YUB[y], this.XLB[x], this.k + 1)) {
                this.CHUNK[x] = y;
                if (++i >= this.n) continue;
                x = this.SORTMIN[i];
            }
            if (i == e) {
                this.fails();
                continue;
            }
            this.ARRAY[y] = y;
            ++e;
        }
        if (i != e) {
            this.fails();
        }
        for (e = 0; e < this.n; ++e) {
            x = this.SORTMAX[e];
            y = this.CHUNK[x];
            while (y < this.ARRAY[y]) {
                this.ARRAY[y] = this.ARRAY[this.ARRAY[y]];
                y = this.ARRAY[y];
            }
            if (this.lexLt(this.XUB[x], this.YLB[y], this.k + 1)) {
                this.fails();
            }
            this.YMATE[y] = x;
            this.XMATE[x] = y;
            this.ARRAY[y] = y + 1;
        }
        for (y = 0; y < this.n; ++y) {
            x = this.YMATE[y];
            if (this.lexFixMax(this.YLB[y], this.YUB[y], this.XUB[x])) continue;
            this.fails();
        }
    }

    private void matchDown() throws ContradictionException {
        int y;
        int e = 0;
        int i = 0;
        int x = this.SORTMAX[this.n - 1];
        for (y = this.n - 1; y >= 0; --y) {
            while (i < this.n && !this.lexLt(this.XUB[x], this.YLB[y], this.k + 1)) {
                this.CHUNK[x] = y;
                if (++i >= this.n) continue;
                x = this.SORTMAX[this.n - i - 1];
            }
            if (i == e) {
                this.fails();
                continue;
            }
            this.ARRAY[y] = y;
            ++e;
        }
        if (i != e) {
            this.fails();
        }
        for (e = this.n - 1; e >= 0; --e) {
            x = this.SORTMIN[e];
            y = this.CHUNK[x];
            while (y > this.ARRAY[y]) {
                this.ARRAY[y] = this.ARRAY[this.ARRAY[y]];
                y = this.ARRAY[y];
            }
            if (this.lexLt(this.YUB[y], this.XLB[x], this.k + 1)) {
                this.fails();
            }
            this.YMATE[y] = x;
            this.XMATE[x] = y;
            this.ARRAY[y] = y - 1;
        }
        for (y = 0; y < this.n; ++y) {
            x = this.YMATE[y];
            if (this.lexFixMin(this.YLB[y], this.YUB[y], this.XLB[x])) continue;
            this.fails();
        }
    }

    private void findSCC() {
        int y = 0;
        int s = 0;
        int t = 0;
        int u = 0;
        while (y - t < this.n) {
            int q;
            int x;
            if (u == 0) {
                x = this.YMATE[y];
                this.ROOT[0] = this.RIGHTMOST[0] = y++;
                this.NODE[0] = this.RIGHTMOST[0];
                this.MAXX[0] = x;
                u = 1;
                t = 1;
                continue;
            }
            if (y < this.n && !this.lexLt(this.XUB[this.MAXX[u - 1]], this.YLB[y], this.k + 1)) {
                int p = x = this.YMATE[y];
                this.NODE[t] = this.ROOT[u] = y;
                ++t;
                while (u > 0 && !this.lexLt(this.YUB[this.RIGHTMOST[u - 1]], this.XLB[x], this.k + 1)) {
                    if (!this.lexLt(this.XUB[p], this.XUB[this.MAXX[--u]], this.k + 1)) continue;
                    p = this.MAXX[u];
                }
                this.RIGHTMOST[u] = y++;
                this.MAXX[u] = p;
                ++u;
                continue;
            }
            int r = this.ROOT[--u];
            do {
                q = this.NODE[--t];
                this.SCC[q] = s++;
            } while (q > r);
        }
    }

    private void narrow() throws ContradictionException {
        int x;
        int s;
        int y;
        int i;
        this.sorter.sort(this.SORTY, this.n, this.sortycomp);
        this.sorter.sort(this.SORTMIN, this.n, this.sortmincomp2);
        this.sorter.sort(this.SORTMAX, this.n, this.sortmaxcomp2);
        int j = 0;
        int d = 0;
        while (d < this.n) {
            i = d;
            y = this.SORTY[i];
            s = this.SCC[y];
            for (d = i + 1; d < this.n && this.SCC[this.SORTY[d]] == s; ++d) {
            }
            while (j < d) {
                y = this.SORTY[i];
                x = this.SORTMIN[j];
                if (!this.lexLt(this.YUB[y], this.XLB[x], this.k + 1)) {
                    if (!this.lexFixMin(this.XLB[x], this.XUB[x], this.YLB[y])) {
                        this.fails();
                    }
                    ++j;
                    continue;
                }
                ++i;
            }
        }
        j = this.n - 1;
        d = this.n - 1;
        while (d >= 0) {
            i = d;
            y = this.SORTY[i];
            s = this.SCC[y];
            for (d = i - 1; d >= 0 && this.SCC[this.SORTY[d]] == s; --d) {
            }
            while (j > d) {
                x = this.SORTMAX[j];
                y = this.SORTY[i];
                if (!this.lexLt(this.XUB[x], this.YLB[y], this.k + 1)) {
                    if (!this.lexFixMax(this.XLB[x], this.XUB[x], this.YUB[y])) {
                        this.fails();
                    }
                    --j;
                    continue;
                }
                --i;
            }
        }
    }

    private void prune() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.DvarLexFixMin(this.X[i], this.XLB[i]);
            this.DvarLexFixMax(this.X[i], this.XUB[i]);
            this.DvarLexFixMin(this.Y[i], this.YLB[i]);
            this.DvarLexFixMax(this.Y[i], this.YUB[i]);
        }
        for (int d = 0; d <= this.m; ++d) {
            int j = 0;
            int i = 0;
            while (i < this.n) {
                int x;
                int y = this.SORTY[i];
                int s = this.SCC[y];
                int xlb = Integer.MAX_VALUE;
                int ylb = Integer.MAX_VALUE;
                int xub = Integer.MIN_VALUE;
                int yub = Integer.MIN_VALUE;
                while (i < this.n && this.SCC[this.SORTY[i]] == s) {
                    y = this.SORTY[i++];
                    x = this.YMATE[y];
                    xlb = Math.min(this.X[x][d].getLB(), xlb);
                    ylb = Math.min(this.Y[y][d].getLB(), ylb);
                    xub = Math.max(this.X[x][d].getUB(), xub);
                    yub = Math.max(this.Y[y][d].getUB(), yub);
                }
                while (j < i) {
                    y = this.SORTY[j++];
                    x = this.YMATE[y];
                    this.prune |= this.X[x][d].updateLowerBound(ylb, this);
                    this.prune |= this.X[x][d].updateUpperBound(yub, this);
                    this.prune |= this.Y[y][d].updateLowerBound(xlb, this);
                    this.prune |= this.Y[y][d].updateUpperBound(xub, this);
                }
            }
        }
    }

    private boolean lexFixMin(int[] L, int[] U, int[] T) {
        boolean AtL = true;
        boolean AtU = true;
        for (int i = 0; i <= this.k; ++i) {
            if (U[i] != T[i]) {
                if (AtU && U[i] < T[i]) {
                    return false;
                }
                AtU = false;
            }
            if (L[i] == T[i]) continue;
            if (AtL && L[i] > T[i]) {
                return true;
            }
            AtL = false;
            L[i] = T[i];
        }
        return true;
    }

    private boolean lexFixMax(int[] L, int[] U, int[] T) {
        boolean AtL = true;
        boolean AtU = true;
        for (int i = 0; i <= this.k; ++i) {
            if (L[i] != T[i]) {
                if (AtL && L[i] > T[i]) {
                    return false;
                }
                AtL = false;
            }
            if (U[i] == T[i]) continue;
            if (AtU && U[i] < T[i]) {
                return true;
            }
            AtU = false;
            U[i] = T[i];
        }
        return true;
    }

    private void DvarLexFixMin(IntVar[] V, int[] T) throws ContradictionException {
        int i;
        int q = 0;
        for (i = 0; i <= this.k; ++i) {
            q = i;
            if (V[i].getLB() > T[i]) {
                return;
            }
            if (V[i].getUB() > T[i]) {
                this.prune |= V[q].updateLowerBound(T[q], this);
                break;
            }
            this.prune |= V[q].instantiateTo(T[q], this);
        }
        ++i;
        while (i <= this.k) {
            if (V[i].getUB() < T[i]) {
                this.prune |= V[q].updateLowerBound(T[q] + 1, this);
                return;
            }
            if (V[i].getUB() > T[i]) {
                return;
            }
            ++i;
        }
    }

    private void DvarLexFixMax(IntVar[] V, int[] T) throws ContradictionException {
        int i;
        int q = 0;
        for (i = 0; i <= this.k; ++i) {
            q = i;
            if (V[i].getUB() < T[i]) {
                return;
            }
            if (V[i].getLB() < T[i]) {
                this.prune |= V[q].updateUpperBound(T[q], this);
                break;
            }
            this.prune |= V[q].instantiateTo(T[q], this);
        }
        ++i;
        while (i <= this.k) {
            if (V[i].getLB() > T[i]) {
                this.prune |= V[q].updateUpperBound(T[q] - 1, this);
            } else if (V[i].getLB() < T[i]) {
                return;
            }
            ++i;
        }
    }

    private boolean lexLt(int[] A1, int[] A2, int n) {
        for (int i = 0; i < n; ++i) {
            if (A1[i] == A2[i]) continue;
            return A1[i] < A2[i];
        }
        return false;
    }
}

