% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_locked_out_constraint.R
\name{add_locked_out_constraint}
\alias{add_locked_out_constraint}
\title{Add locked out constraint}
\usage{
add_locked_out_constraint(problem, data)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}

\item{data}{\code{\link[terra:rast]{terra::rast()}}  or \code{\link[terra:vect]{terra::vect()}} Either a raster object
containing binary values hat indicate which planning units cannot be selected
for any restoration (i.e., cells with a value equal one are locked out from
the solution), or a vector object whose features correspond to the locked
out areas. See the function \code{add_available_areas_constraint()} to get a locked
out constraint from allowed restoration areas.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Add constraint to a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object
to specify that certain planning units cannot be selected
for restoration activities.
}
\details{
Locked out constraints can be used to incorporate a wide range of
criteria into restoration planning problems.
They can be used to account for existing land-use practices,
feasibility of restoration activities, and stakeholder preferences.
For example, locked out constraints can be used to
ensure that urban areas are not selected for restoration.
Additionally, if restoration activities can only be implemented depending
on certain conditions -- such as places where landscape slope is not
too steep -- then locked out constraints could be used to ensure
restoration activities are not prioritized for places where they
could not be implemented.
Furthermore, if stakeholders require solutions that do not prioritize
particular places for restoration, then locked out constraints
can also be used to achieve this.
See \code{add_available_areas_constraint()}, which achieve the same as the locked
out constraint by defining areas that ARE available for restoration.
}
\examples{
\donttest{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

locked_out_data <- rast(
 system.file("extdata", "locked_out.tif", package = "restoptr")
)

# plot data
plot(rast(list(habitat_data, locked_out_data)), nc = 2)

# create problem with locked out constraints
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  set_max_iic_objective() \%>\%
  add_restorable_constraint(
    min_restore = 5,
    max_restore = 5,
  ) \%>\%
  add_locked_out_constraint(data = locked_out_data) \%>\%
  add_settings(time_limit = 1)

# print problem
print(p)

# solve problem
s <- solve(p)

# plot solution
plot(s)
}
}
\seealso{
Other constraints: 
\code{\link{add_available_areas_constraint}()},
\code{\link{add_compactness_constraint}()},
\code{\link{add_components_constraint}()},
\code{\link{add_connected_constraint}()},
\code{\link{add_min_iic_constraint}()},
\code{\link{add_min_mesh_constraint}()},
\code{\link{add_restorable_constraint}()}
}
\concept{constraints}
