% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_add.R
\encoding{UTF-8}
\name{co2_add}
\alias{co2_add}
\title{Calculate CO2 to add to water}
\usage{
co2_add(goal_pco2, start_pH, vol, temp = 25, sal = 35, TA = NULL,
  atm_pres = 1013.25)
}
\arguments{
\item{goal_pco2}{the desired pCO2 in the water (uatm).}

\item{start_pH}{pH of the water before CO2 is added (total scale).}

\item{vol}{volume of the water (liter).}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu. If \code{sal} < 26 psu, then \code{TA} must be provided.}

\item{TA}{(optional) total alkalinity (umol / kg). If undefined TA is estimated from salinity using \code{\link{guess_TA}}.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\value{
moles of CO2 gas to be added to the seawater.
}
\description{
Calculates the moles of CO2 gas to be added to a volume of seawater to achieve the desired pCO2. Useful for ocean acidification experiments where CO2 treatments are desired.
}
\note{
It is assumed that all of the CO2 added dissolves and remains in solution. This can be achieved (almost completely) by bubbling CO2 according to Jokiel et al. 2014.
}
\examples{
# I want the 50 L reservoir to have a pCO2 = 1000 uatm. It currently has a pH of 7.88.
# How many moles of CO2 gas should be added to the water to reach my desired pCO2?
co2_add(goal_pco2 = 1000, start_pH = 7.88, vol = 50)

}
\references{
Jokiel PL, Bahr KD, Rodgers KS. 2014. Low-cost, high-flow mesocosm system for simulating ocean acidification with CO2 gas. Limnol Oceanogr Methods. 12:313–322.
}
\seealso{
\code{\link{co2_rate}}, \code{\link{flush_carb}}, \code{\link[seacarb]{carb}}, \code{\link{peri_pump}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
