% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_farming.R
\name{run_farm_sim}
\alias{run_farm_sim}
\title{Initialise individuals and simulate farming}
\usage{
run_farm_sim(
  mine_output,
  N = 1000,
  xdim = 100,
  ydim = 100,
  repro = "sexual",
  neutral_loci = 1000,
  max_age = 9,
  min_age_move = 0,
  max_age_move = 9,
  min_age_reproduce = 0,
  max_age_reproduce = 9,
  min_age_feed = 0,
  max_age_feed = 9,
  food_consume = 0.25,
  pesticide_consume = 0.1,
  rand_age = FALSE,
  move_distance = 1,
  food_needed_surv = 0.25,
  pesticide_tolerated_surv = 0.1,
  food_needed_repr = 0,
  pesticide_tolerated_repr = 0,
  reproduction_type = "lambda",
  mating_distance = 1,
  lambda_value = 1,
  movement_bouts = 1,
  selfing = TRUE,
  feed_while_moving = FALSE,
  pesticide_while_moving = FALSE,
  mortality_type = 0,
  age_food_threshold = 0,
  age_pesticide_threshold = 0,
  farms = 4,
  time_steps = 100,
  mutation_pr = 0,
  crossover_pr = 0,
  mutation_type = 0,
  net_mu_layers = 0,
  net_mu_dir = 0,
  mutation_direction = 0,
  crop_rotation_type = 2,
  crop_rotation_time = 1,
  pesticide_rotation_type = 2,
  pesticide_rotation_time = 1,
  crop_per_cell = 1,
  pesticide_per_cell = 1,
  crop_sd = 0,
  pesticide_sd = 0,
  crop_min = 0,
  crop_max = 1000,
  pesticide_min = 0,
  pesticide_max = 1000,
  crop_number = 2,
  pesticide_number = 1,
  print_inds = FALSE,
  print_gens = TRUE,
  print_last = FALSE,
  K_on_birth = 1e+06,
  pesticide_start = 0,
  immigration_rate = 0,
  get_f_coef = FALSE,
  get_stats = TRUE,
  metabolism = 0,
  baseline_metabolism = 0,
  min_age_metabolism = 1,
  max_age_metabolism = 9
)
}
\arguments{
\item{mine_output}{The output from mine_gmatrix}

\item{N}{Number of individuals to be initialised}

\item{xdim}{Horizontal dimensions of the landscape}

\item{ydim}{Vertical dimensions of the landscape}

\item{repro}{Type of reproduction allowed: "asexual", "sexual", and
"biparental". Note that if repro > 0, this causes a diploid genome.}

\item{neutral_loci}{The number of neutral loci individuals have}

\item{max_age}{The maximum age of an individual}

\item{min_age_move}{The minimum age at which an individual can move}

\item{max_age_move}{The maximum age at which an individual can move}

\item{min_age_reproduce}{The minimum age which an individual can reproduce}

\item{max_age_reproduce}{The maximum age which an individual can reproduce}

\item{min_age_feed}{The minimum age at which an individual feeds}

\item{max_age_feed}{The maximum age at which an individual feeds}

\item{food_consume}{The amount of food consumed during feeding}

\item{pesticide_consume}{Amount of pesticide consumed while on a cell}

\item{rand_age}{Initialise individuals with a random age}

\item{move_distance}{Maximum cells moved in one bout of movement}

\item{food_needed_surv}{Food needed to survive (if over min_age_feed)}

\item{pesticide_tolerated_surv}{Pesticide tolerated by individual}

\item{food_needed_repr}{Food needed to reproduce 1 offspring}

\item{pesticide_tolerated_repr}{Pesticide tolerated to allow reproduction}

\item{reproduction_type}{Poisson reproduction ("lambda") vs "food_based"}

\item{mating_distance}{Distance in cells within which mate is available}

\item{lambda_value}{individual value for poisson reproduction}

\item{movement_bouts}{Number of bouts of movement per time step}

\item{selfing}{If sexual reproduction, is selfing allowed?}

\item{feed_while_moving}{Do individuals feed after each movement bout?}

\item{pesticide_while_moving}{Individuals consume pesticide after move bout?}

\item{mortality_type}{Type of mortality (currently only one option)}

\item{age_food_threshold}{Age at which food threshold is enacted}

\item{age_pesticide_threshold}{Age at which pesticide threshold is enacted}

\item{farms}{How many farms should there be on the landscape?}

\item{time_steps}{Time steps in the simulation}

\item{mutation_pr}{Probability of a loci mutating}

\item{crossover_pr}{Probability of crossover at homologous loci}

\item{mutation_type}{Type of mutation used}

\item{net_mu_layers}{Layers of the network allowed to mutate}

\item{net_mu_dir}{Layers mutate from loci to (1) or traits back (0)}

\item{mutation_direction}{Is mutation directional (unlikely to need)}

\item{crop_rotation_type}{None (1) or random (2) rotation of crop type}

\item{crop_rotation_time}{How frequently are the crops rotated?}

\item{pesticide_rotation_type}{None (1) or random (2) rotation of pesticide}

\item{pesticide_rotation_time}{How frequently are the pesticides rotated?}

\item{crop_per_cell}{How much crop is put on a single cell?}

\item{pesticide_per_cell}{How much pesticide is put on a single cell?}

\item{crop_sd}{What is the standard deviation of crop on a cell?}

\item{pesticide_sd}{What is the standard deviation of pesticide on a cell?}

\item{crop_min}{What is the minimum crop amount allowed per cell?}

\item{crop_max}{What is the maximum crop amount allowed per cell?}

\item{pesticide_min}{What is the minimum pesticide amount allowed per cell?}

\item{pesticide_max}{What is the maximum pesticide amount allowed per cell?}

\item{crop_number}{How many crops exist on the landscape?}

\item{pesticide_number}{How many pesticides are applied on the landscape?}

\item{print_inds}{Should the full list of individuals be printed? (CAREFUL)}

\item{print_gens}{Should a summary of each time step be printed?}

\item{print_last}{Should the last time step of individuals be printed?}

\item{K_on_birth}{Is there a carrying capacity applied on newborns?}

\item{pesticide_start}{What time step should pesticide start being applied?}

\item{immigration_rate}{Mean number of immigrants per time step}

\item{get_f_coef}{Get the inbreeding coefficient (not for asexual)}

\item{get_stats}{Get population level statistics in a CSV printout}

\item{metabolism}{The rate at which food consumed is burned in a time step}

\item{baseline_metabolism}{A fixed baseline rate added to 'metabolism'}

\item{min_age_metabolism}{The minimum age affected by metabolism}

\item{max_age_metabolism}{The maximum age affected by metabolism}
}
\value{
The output in the R console is a list with two elements; the first 
element is a vector of parameter values used by the model, and the second 
element is the landscape in the simulation. The most relevant output will be
produced as CSV files within the working directory. When get_stats = TRUE, 
a file named 'population_data.csv' is produced in the working directory. When
print_last = TRUE, a complete array of all individuals and their 
characteristics is printed for the last time step in the working directory in
a file named 'last_time_step.csv' (for large simulations, this file can be 
> 1GB in size). When print_inds = TRUE, a complete array of all individuals 
in all time steps is produced in the working directory in a file named
'individuals.csv' (use this option with extreme caution for all but the
smallest simulations).
}
\description{
Initialises a new set of individuals and then simulates farming over time.
This is the main function that runs individual-based simulations of crop and
pesticide use and the evolution of pesticide resistance over time. To run 
this function, output from the mine_gmatrix function is required to specify
the covariance structure of individual traits and individual genomes. The
arguments to this function are used to initialise a landscape with the 
make_landscape function and initialise individuals with the initialise_inds
function. After initialisation, the simulation continues for up to a set 
number of time steps (unless extinction occurs), and individuals on the
landscape feed, encounter pesticide, move, reproduce, and die depending upon
the arguments specified in this function. After a specified number of time
steps, the crop or pesticide applied to a landscape cell can also change. The
end result is an evolving population of individuals that express traits 
that can potentially affect fitness (e.g., food consumption, pesticide
consumption, movement). Population level statistics are calculated by 
default and printed to a CSV, but individual level data (which includes all 
individual characteristics in a large table) need to be turned on because 
files can become extremely large (use print_inds with extreme caution and
print_last with care).
}
\examples{
gmt       <- matrix(data = 0, nrow = 4, ncol = 4);
diag(gmt) <- 1;
mg        <- mine_gmatrix(gmatrix = gmt, loci = 4, layers = 3, indivs = 100, 
                         npsize = 100, max_gen = 2, prnt_out = FALSE);
sim       <- run_farm_sim(mine_output = mg, N = 100, xdim = 40, ydim = 40, 
                         repro = "asexual", time_steps = 1, 
                         print_inds = FALSE, print_gens = FALSE,
                         print_last = FALSE, get_stats = FALSE);
}
