% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_diss.R
\name{cor_diss}
\alias{cor_diss}
\title{Correlation and moving correlation dissimilarity measurements (cor_diss)}
\usage{
cor_diss(Xr, Xu = NULL, ws = NULL,
         center = TRUE, scale = FALSE)
}
\arguments{
\item{Xr}{a matrix.}

\item{Xu}{an optional matrix containing data of a second set of observations.}

\item{ws}{for moving correlation dissimilarity, an odd integer value which
specifies the window size. If \code{ws = NULL}, then the window size will be
equal to the number of variables (columns), i.e. instead moving correlation,
the normal correlation will be used. See details.}

\item{center}{a logical indicating if the spectral data \code{Xr} (and
\code{Xu} if specified) must be centered. If \code{Xu} is provided, the data
is scaled on the basis of \mjeqn{Xr \cup Xu}{Xr U Xu}.}

\item{scale}{a logical indicating if \code{Xr} (and \code{Xu} if specified)
must be scaled. If \code{Xu} is provided the data is scaled on the basis
of \mjeqn{Xr \cup Xu}{Xr U Xu}.}
}
\value{
a matrix of the computed dissimilarities.
}
\description{
\loadmathjax
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#satble'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}

Computes correlation and moving correlation dissimilarity matrices.
}
\details{
The correlation dissimilarity \mjeqn{d}{d} between two observations
\mjeqn{x_i}{x_i} and \mjeqn{x_j}{x_j} is based on the Perason's
correlation coefficient (\mjeqn{\rho}{\rho}) and it can be computed as
follows:

\mjdeqn{d(x_i, x_j) = \frac{1}{2}((1 - \rho(x_i, x_j)))}{d(x_i, x_j) = 1/2 (1 - \rho(x_i, x_j))}

The above formula is used when \code{ws = NULL}.
On the other hand (when \code{ws != NULL}) the moving correlation
dissimilarity between two observations \mjeqn{x_i}{x_i} and \mjeqn{x_j}{x_j}
is computed as follows:

\mjdeqn{d(x_i, x_j; ws) = \frac{1}{2 ws}\sum_{k=1}^{p-ws}1 - \rho(x_{i,(k:k+ws)}, x_{j,(k:k+ws)})}{d(x_i, x_j) = 1/(2 ws)\sum_(k=1)^{p-ws}(1 - \rho(x_(i,k:k+ws), x_(j,k:k+ws)))}

where \mjeqn{ws}{ws} represents a given window size which rolls sequentially
from 1 up to \mjeqn{p - ws}{p - ws} and  \mjeqn{p}{p} is the number of
variables of the observations.

The function does not accept input data containing missing values.
}
\examples{
\donttest{
library(prospectr)
data(NIRsoil)

Xu <- NIRsoil$spc[!as.logical(NIRsoil$train), ]
Xr <- NIRsoil$spc[as.logical(NIRsoil$train), ]

cor_diss(Xr = Xr)

cor_diss(Xr = Xr, Xu = Xu)

cor_diss(Xr = Xr, ws = 41)

cor_diss(Xr = Xr, Xu = Xu, ws = 41)
}
}
\author{
Antoine Stevens and \href{https://orcid.org/0000-0002-5369-5120}{Leonardo Ramirez-Lopez}
}
