% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxtractogon.R
\name{rxtractogon}
\alias{rxtractogon}
\title{Extract environmental data in a polygon using 'ERDDAP' and 'rerddap'.}
\usage{
rxtractogon(dataInfo, parameter, xcoord = NULL, ycoord = NULL,
  zcoord = NULL, tcoord = NULL, xName = "longitude",
  yName = "latitude", zName = "altitude", tName = "time",
  verbose = FALSE, cache_remove = TRUE)
}
\arguments{
\item{dataInfo}{- the return from an 'rerddap:info' call to an 'ERDDAP' server}

\item{parameter}{- character string containing the name of the parameter to extract}

\item{xcoord}{- array giving longitudes (in decimal
degrees East, either 0-360 or -180 to 180) of polygon}

\item{ycoord}{-  array giving latitudes (in decimal
degrees N; -90 to 90)of polygon}

\item{zcoord}{-  a real number with the z-coordinate(usually altitude or depth)}

\item{tcoord}{- 2-array of minimum and maximum times as 'YYYY-MM-DD'}

\item{xName}{- character string with name of the xcoord in the 'ERDDAP' dataset (default "longitude")}

\item{yName}{- character string with name of the ycoord in the 'ERDDAP' dataset (default "latitude")}

\item{zName}{- character string with name of the zcoord in the 'ERDDAP' dataset (default "altitude")}

\item{tName}{- character string with name of the tcoord in the 'ERDDAP' dataset (default "time")}

\item{verbose}{- logical variable (default FALSE) if the the URL request should be verbose}

\item{cache_remove}{- logical variable (default TRUE) whether to delete 'rerddap' cache}
}
\value{
structure with data and dimensions
\itemize{
  \item extract$data - the masked data array dimensioned (lon,lat,time)
  \item extract$varname - the name of the parameter extracted
  \item extract$datasetname - ERDDAP dataset name
  \item extract$longitude - the longitudes on some scale as request
  \item extract$latitude - the latitudes always going south to north
  \item extract$time - the times of the extracts
  }
}
\description{
\code{rxtractogon} uses the R program 'rerddap' to extract environmental data
from an 'ERDDAP' server in a polygon through time.
}
\section{Details}{

 rxtractogon extracts the data from the smallest bounding box that contains
 the polygon, and then uses the function "point.in.polygon" from the "sp"
 package to mask out the areas outside of the polygon.
 rxtractogon only works with datasets defined
 on a latitude and longitude grid.
}

\examples{
# toy example to show use
# and keep execution time low
\donttest{
dataInfo <- rerddap::info('erdHadISST')
}
parameter <- 'sst'
tcoord <- c("2016-06-15")
xcoord <- mbnms$Longitude[1:3]
ycoord <- mbnms$Latitude[1:3]
sanctSST <- rxtractogon (dataInfo, parameter=parameter, xcoord = xcoord,
                         ycoord = ycoord,  tcoord= tcoord)
\donttest{
xcoord <- mbnms$Longitude
ycoord <- mbnms$Latitude
dataInfo <- rerddap::info('etopo180')
parameter = 'altitude'
xName <- 'longitude'
yName <- 'latitude'
bathy <- rxtractogon (dataInfo, parameter = parameter, xcoord = xcoord,
                      ycoord = ycoord)
}
}
