% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/grid.R
\name{griddap}
\alias{griddap}
\title{Get ERDDAP griddap data.}
\usage{
griddap(x, ..., fields = "all", stride = 1, fmt = "nc", ncdf = "ncdf",
  url = eurl(), store = disk(), read = TRUE, callopts = list())
}
\arguments{
\item{x}{Anything coercable to an object of class info. So the output of a call to
\code{\link{info}}, or a datasetid, which will internally be passed through
\code{\link{info}}}

\item{...}{Dimension arguments. See examples. Can be any 1 or more of the dimensions
for the particular dataset - and the dimensions vary by dataset. For each dimension,
pass in a vector of length two, with min and max value desired.}

\item{fields}{(character) Fields to return, in a character vector.}

\item{stride}{(integer) How many values to get. 1 = get every value, 2 = get
every other value, etc. Default: 1 (i.e., get every value)}

\item{fmt}{(character) One of csv or nc (for netcdf). Default: nc}

\item{ncdf}{(character) One of ncdf or ncdf4. If ncdf, use the package
\code{\link{ncdf}} to read netcdf files. If ncdf4, use the package
\code{ncdf4}. \code{\link{ncdf}} package is required for this package to be
installed, and should be easily installable across platforms. However, \code{ncdf4}
is likely not installable on Windows OS's. Ignored if \code{fmt = "csv"}. Default: ncdf}

\item{url}{A URL for an ERDDAP server. Default: \url{http://upwell.pfeg.noaa.gov/erddap/}}

\item{store}{One of \code{\link{disk}} (default) or \code{\link{memory}}. You
can pass options to \code{\link{disk}}}

\item{read}{(logical) Read data into memory or not. Does not apply when \code{store}
parameter is set to memory (which reads data into memory). For large csv, or
especially netcdf files, you may want to set this to \code{FALSE}, which simply
returns a summary of the dataset - and you can read in data piecemeal later.
Default: \code{TRUE}}

\item{callopts}{Pass on curl options to \code{\link[httr]{GET}}}
}
\value{
An object of class \code{griddap_csv} if csv chosen or \code{griddap_nc}
if nc file format chosen. These two classes are a thin wrapper around a data.frame,
so the data you get back is a data.frame with metadata attached as
attributes, along with a summary of the netcdf file (if \code{fmt="nc"}). If
\code{read=FALSE}, you get back an empty data.frame.
}
\description{
Get ERDDAP griddap data.
}
\details{
Details:
}
\section{Dimensions and Variables}{

ERDDAP grid dap data has this concept of dimenions vs. variables. Dimensions are things
like time, latitude, longitude, altitude, and depth. Whereas variables are the measured
variables, e.g., temperature, salinity, air.

You can't separately adjust values for dimensions for different variables. So, here's
how it's gonna work:

Pass in lower and upper limits you want for each dimension as a vector (e.g., \code{c(1,2)}),
or leave to defaults (i.e., don't pass anything to a dimension). Then pick which variables
you want returned via the \code{fields} parameter. If you don't pass in options to the
\code{fields} parameter, you get all variables back.

To get the dimensions and variables, along with other metadata for a dataset, run
\code{\link{info}}, and each will be shown, with their min and max values, and some
other metadata.
}

\section{Where does the data go?}{

You can choose where data is stored. Be careful though. You can easily get a
single file of hundreds of MB's (upper limit: 2 GB) in size with a single request.
To the \code{store} parameter, pass \code{\link{memory}} if you want to store the data
in memory (saved as a data.frame), or pass \code{\link{disk}} if you want to store on
disk in a file. Note that \code{\link{memory}} and \code{\link{disk}} are not
character strings, but function calls. \code{\link{memory}} does not accept any
inputs, while \code{\link{disk}} does. Possibly will add other options, like
\dQuote{sql} for storing in a SQL database.
}
\examples{
\dontrun{
# single variable dataset
## You can pass in the outpu of a call to info
(out <- info('noaa_esrl_027d_0fb5_5d38'))
(res <- griddap(out,
 time = c('2012-01-01','2012-06-12'),
 latitude = c(21, 18),
 longitude = c(-80, -75)
))
## Or, pass in a dataset id
(res <- griddap('noaa_esrl_027d_0fb5_5d38',
 time = c('2012-01-01','2012-06-12'),
 latitude = c(21, 18),
 longitude = c(-80, -75)
))

# multi-variable dataset
(out <- info('noaa_gfdl_5081_7d4a_7570'))
(res <- griddap(out,
 time = c('2005-11-01','2006-01-01'),
 latitude = c(20, 21),
 longitude = c(10, 11),
 read = FALSE
))
(res <- griddap(out, time = c('2005-11-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = 'uo'))
(res <- griddap(out, time = c('2005-11-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = 'uo', stride = c(1,2,1,2)))
(res <- griddap(out, time = c('2005-11-01','2006-01-01'), latitude = c(20, 21),
   longitude = c(10, 11), fields = c('uo','so')))

# multi-variable dataset
(out <- info('noaa_gfdl_3c96_7879_a9d3'))
(res <- griddap(out,
 time = c('2005-11-01','2005-11-10'),
 latitude = c(20, 21),
 longitude = c(2, 3)
))

# Write to memory (within R), or to disk
(out <- info('erdQSwindmday'))
## disk, by default (to prevent bogging down system w/ large datasets)
## you can also pass in path and overwrite options to disk()
(res <- griddap(out,
 time = c('2006-07-11','2006-07-20'),
 longitude = c(166, 170),
 store = disk()
))
## the 2nd call is much faster as it's mostly just the time of reading in the table from disk
system.time( griddap(out,
 time = c('2006-07-11','2006-07-15'),
 longitude = c(10, 15),
 store = disk()
) )
system.time( griddap(out,
 time = c('2006-07-11','2006-07-15'),
 longitude = c(10, 15),
 store = disk()
) )

## memory
(res <- griddap("noaa_gfdl_3c96_7879_a9d3",
 time = c('2005-11-01','2005-11-10'),
 latitude = c(20, 21),
 longitude = c(4, 5),
 store = memory()
))

## Use ncdf4 package to parse data
info("hawaii_463b_5b04_35b7")
(res <- griddap("hawaii_463b_5b04_35b7",
 time = c('2015-01-01','2015-01-03'),
 latitude = c(14, 15),
 longitude = c(75, 76),
 ncdf = "ncdf4"
))

# Get data in csv format
## by default, we get netcdf format data
(res <- griddap('noaa_gfdl_5081_7d4a_7570',
 time = c('2005-11-01','2005-11-06'),
 latitude = c(20, 21),
 longitude = c(10, 11),
 fmt = "csv"
))

# Use a different ERDDAP server url
## NOAA IOOS PacIOOS
url = "http://oos.soest.hawaii.edu/erddap/"
out <- info("NOAA_DHW", url = url)
(res <- griddap(out,
 time = c('2005-11-01','2006-01-01'),
 latitude = c(21, 20),
 longitude = c(10, 11)
))
## pass directly into griddap()
griddap("NOAA_DHW", url = url,
 time = c('2005-11-01','2006-01-01'),
 latitude = c(21, 20),
 longitude = c(10, 11)
)

# You don't have to pass in all of the dimensions
## They do have to be named!
griddap(out, time = c('2005-11-01','2005-11-03'))

# Using 'last'
## with time
griddap('noaa_gfdl_5081_7d4a_7570',
 time = c('last-5','last'),
 latitude = c(21, 18),
 longitude = c(3, 5)
)
## with latitude
griddap('noaa_gfdl_5081_7d4a_7570',
  time = c('2008-01-01','2009-01-01'),
  latitude = c('last', 'last'),
  longitude = c(3, 5)
)
## with longitude
griddap('noaa_gfdl_5081_7d4a_7570',
 time = c('2008-01-01','2009-01-01'),
 latitude = c(21, 18),
 longitude = c('last', 'last')
)
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/rest.html}
}

