% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{cropInputs}
\alias{cropInputs}
\alias{cropInputs.default}
\alias{fixErrors}
\alias{fixErrors.default}
\alias{projectInputs}
\alias{projectInputs.default}
\alias{maskInputs}
\alias{writeOutputs}
\alias{writeOutputs.default}
\title{Crop a \verb{Spatial*} or \verb{Raster*} object}
\usage{
cropInputs(
  x,
  studyArea,
  rasterToMatch,
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{cropInputs}{default}(x, ...)

fixErrors(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)

\method{fixErrors}{default}(
  x,
  objectName,
  attemptErrorFixes = TRUE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  testValidity = getOption("reproducible.testValidity", TRUE),
  ...
)

projectInputs(
  x,
  targetCRS,
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{projectInputs}{default}(x, targetCRS, ...)

maskInputs(x, studyArea, ...)

writeOutputs(
  x,
  ...,
  overwrite = getOption("reproducible.overwrite", NULL),
  verbose = getOption("reproducible.verbose", 1)
)

\method{writeOutputs}{default}(
  x,
  ...,
  overwrite = getOption("reproducible.overwrite", FALSE),
  verbose = getOption("reproducible.verbose", 1)
)
}
\arguments{
\item{x}{The object save to disk i.e., write outputs}

\item{studyArea}{\verb{SpatialPolygons*} object used for masking and possibly cropping
if no \code{rasterToMatch} is provided.
If not in same CRS, then it will be \code{spTransform}ed to
CRS of \code{x} before masking. Currently, this function will not reproject the
\code{x}. Optional in \code{postProcess}.}

\item{rasterToMatch}{Template \verb{Raster*} object passed to the \code{to} argument of
\code{\link[=projectTo]{projectTo()}}, thus will changing the
resolution and projection of \code{x}.
See details in \code{\link[=postProcessTo]{postProcessTo()}}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{...}{Passed into \code{\link[=writeTo]{writeTo()}}}

\item{objectName}{Optional. This is only for messaging; if provided, then messages relayed
to user will mention this.}

\item{attemptErrorFixes}{Will attempt to fix known errors. Currently only some failures
for \verb{SpatialPolygons*} are attempted.
Notably with \code{terra::buffer(..., width = 0)}.
Default \code{TRUE}, though this may not be the right action for all cases.}

\item{useCache}{Logical, default \code{getOption("reproducible.useCache", FALSE)}, whether
Cache is used on the internal \code{terra::buffer} command.}

\item{testValidity}{Logical. If \code{TRUE}, the a test for validity will happen
before actually running buffering (which is the solution in most
cases). However, sometimes it takes longer to test for validity
than just buffer without testing (there are no consequences of
buffering if everything is valid). If \code{FALSE}, then the
test will be skipped and the buffering will happen regardless.
If \code{NA}, then all testing and buffering will be skipped.}

\item{targetCRS}{The CRS of x at the end  of this function (i.e., the goal)}

\item{overwrite}{Logical. Should file being written overwrite an existing file if it exists.}

\item{cores}{An \verb{integer*} or \code{'AUTO'}. This will be used if \code{gdalwarp} is
triggered. \verb{'AUTO'*} will calculate 90\% of the total
number of cores in the system, while an integer or rounded
float will be passed as the exact number of cores to be used.}

\item{filename2}{File name passed to \code{\link[=writeTo]{writeTo()}}.}
}
\value{
A GIS file (e.g., RasterLayer, SpatRaster etc.) that has been
appropriately cropped.

A GIS file (e.g., RasterLayer, SpatRaster etc.) that has been
attempted to be fixed, if it finds errors.

A file of the same type as starting, but with projection (and possibly
other characteristics, including resolution, origin, extent if changed).

A GIS file (e.g., RasterLayer, SpatRaster etc.) that has been
appropriately reprojected.

A GIS file (e.g., RasterLayer, SpatRaster etc.) that has been
appropriately masked.

A GIS file (e.g., SpatRaster etc.) that has been
appropriately written to disk. In the case of vector datasets, this will
be a side effect. In the case of gridded objects (Raster*, SpatRaster), the
object will have a file-backing.
}
\description{
This function is deprecated. Use \code{cropTo}. If used, all arguments will be passed
to \code{cropTo} anyway.

\code{fixErrors} --> \code{fixErrosTerra}

Deprecated. Use \code{\link[=projectTo]{projectTo()}}.

\code{maskInputs} is deprecated. Use \code{\link[=maskTo]{maskTo()}}

See \code{\link[=writeTo]{writeTo()}}
}
\examples{
if (requireNamespace("terra")) {
  r <- terra::rast(terra::ext(0,100,0,100), vals = 1:1e2)

  tf <- tempfile(fileext = ".tif")
  writeOutputs(r, tf)
}
}
\seealso{
\code{\link[=fixErrorsIn]{fixErrorsIn()}}, \code{\link[=postProcessTo]{postProcessTo()}}, \code{\link[=postProcess]{postProcess()}}

\code{\link[=projectTo]{projectTo()}}

\code{\link[=maskTo]{maskTo()}}, \code{\link[=postProcessTo]{postProcessTo()}} for related examples
}
\author{
Eliot McIntire, Jean Marchal, Ian Eddy, and Tati Micheletti

Eliot McIntire and Jean Marchal
}
\keyword{internal}
