% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcessParams}
\alias{preProcessParams}
\alias{preProcess}
\title{Download, Checksum, Extract files}
\usage{
preProcessParams(n = NULL)

preProcess(
  targetFile = NULL,
  url = NULL,
  archive = NULL,
  alsoExtract = NULL,
  destinationPath = getOption("reproducible.destinationPath", "."),
  fun = NULL,
  dlFun = NULL,
  quick = getOption("reproducible.quick"),
  overwrite = getOption("reproducible.overwrite", FALSE),
  purge = FALSE,
  useCache = getOption("reproducible.useCache", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  .tempPath,
  ...
)
}
\arguments{
\item{n}{Number of non-null arguments passed to \code{preProcess}.
E.g., passing \code{n = 1} returns combinations with only a single non-NULL parameter.
If \code{NULL} (default), all parameter combinations are returned.}

\item{targetFile}{Character string giving the path to the eventual file
(raster, shapefile, csv, etc.) after downloading and extracting from a zip
or tar archive. This is the file \emph{before} it is passed to
\code{postProcess}. Currently, the internal checksumming does not checksum
the file after it is \code{postProcess}ed (e.g., cropped/reprojected/masked).
Using \code{Cache} around \code{prepInputs} will do a sufficient job in these cases.
See table in \code{\link{preProcess}}.}

\item{url}{Optional character string indicating the URL to download from.
If not specified, then no download will be attempted. If not entry
exists in the \code{CHECKSUMS.txt} (in \code{destinationPath}), an entry
will be created or appended to. This \code{CHECKSUMS.txt} entry will be used
in subsequent calls to
\code{prepInputs} or \code{preProcess}, comparing the file on hand with the ad hoc
\code{CHECKSUMS.txt}. See table in \code{\link{preProcess}}.}

\item{archive}{Optional character string giving the path of an archive
containing \code{targetFile}, or a vector giving a set of nested archives
(e.g., \code{c("xxx.tar", "inner.zip", "inner.rar")}). If there is/are (an) inner
archive(s), but they are unknown, the function will try all until it finds
the \code{targetFile}. See table in \code{\link{preProcess}}.}

\item{alsoExtract}{Optional character string naming files other than
\code{targetFile} that must be extracted from the \code{archive}. If
\code{NULL}, the default, then it will extract all files. Other options:
\code{"similar"} will extract all files with the same filename without
file extension as \code{targetFile}. \code{NA} will extract nothing other
than \code{targetFile}. A character string of specific file names will cause
only those to be extracted. See table in \code{\link{preProcess}}.}

\item{destinationPath}{Character string of a directory in which to download
and save the file that comes from \code{url} and is also where the function
will look for \code{archive} or \code{targetFile}. NOTE (still experimental):
To prevent repeated downloads in different locations, the user can also set
\code{options("reproducible.inputPaths")} to one or more local file paths to
search for the file before attempting to download. Default for that option is
\code{NULL} meaning do not search locally.}

\item{fun}{Function or character string indicating the function to use to load
\code{targetFile} into an \code{R} object, e.g., in form with package name:
\code{"raster::raster"}. If passing a custom function, it must be a function of
\code{x}, e.g., \code{loadFun <- function(x) shapefile(x)}.
NOTE: passing \code{NULL} will skip loading object into R.}

\item{dlFun}{Optional "download function" name, such as \code{"raster::getData"}, which does
custom downloading, in addition to loading into R. Still experimental.}

\item{quick}{Logical. This is passed internally to \code{\link{Checksums}}
(the quickCheck argument), and to
\code{\link{Cache}} (the quick argument). This results in faster, though
less robust checking of inputs. See the respective functions.}

\item{overwrite}{Logical. Should downloading and all the other actions occur
even if they pass the checksums or the files are all there.}

\item{purge}{Logical or Integer. \code{0/FALSE} (default) keeps existing
\code{CHECKSUMS.txt} file and
\code{prepInputs} will write or append to it. \code{1/TRUE} will deleted the entire
\code{CHECKSUMS.txt} file. Other options, see details.}

\item{useCache}{Passed to \code{Cache} in various places.
Defaults to \code{getOption("reproducible.useCache")}.}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \code{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{.tempPath}{Optional temporary path for internal file intermediate steps.
Will be cleared on.exit from this function.}

\item{...}{Additional arguments passed to \code{fun} (i.e,. user supplied),
 \code{\link{postProcess}} and \code{\link[reproducible]{Cache}}.
Since \code{...} is passed to \code{\link{postProcess}}, these will
\code{...} will also be passed into the inner
functions, e.g., \code{\link{cropInputs}}. See details and examples.}
}
\value{
A list with 5 elements: \code{checkSums} (the result of a \code{Checksums}
after downloading), \code{dots} (cleaned up \code{...}, including deprecated argument checks),
\code{fun} (the function to be used to load the \code{preProcess}ed object from disk),
and \code{targetFilePath} (the fully qualified path to the \code{targetFile}).
}
\description{
This does downloading (via \code{downloadFile}), checksumming (\code{Checksums}),
and extracting from archives (\code{extractFromArchive}), plus cleaning up of input
arguments (e.g., paths, function names).
This is the first stage of three used in \code{prepInputs}.
}
\section{Combinations of \code{targetFile}, \code{url}, \code{archive}, \code{alsoExtract}}{


  Use \code{preProcessParams()} for a table describing various parameter combinations and their
  outcomes.

 \code{*} If the \code{url} is a file on Google Drive, checksumming will work
 even without a \code{targetFile} specified because there is an initial attempt
 to get the remove file information (e.g., file name). With that, the connection
 between the \code{url} and the filename used in the \file{CHECKSUMS.txt} file can be made.
}

\author{
Eliot McIntire
}
