% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{CacheDigest}
\alias{CacheDigest}
\title{The exact digest function that \code{Cache} uses}
\usage{
CacheDigest(objsToDigest, algo = "xxhash64", calledFrom = "Cache", ...)
}
\arguments{
\item{objsToDigest}{A list of all the objects (e.g., arguments) to be digested}

\item{algo}{The algorithms to be used; currently available choices are
    \code{md5}, which is also the default, \code{sha1}, \code{crc32},
    \code{sha256}, \code{sha512}, \code{xxhash32}, \code{xxhash64},
    \code{murmur32} and \code{spookyhash}.}

\item{calledFrom}{a Character string, length 1, with the function to
compare with. Default is "Cache". All other values may not produce
robust CacheDigest results.}

\item{...}{passed to \code{.robustDigest}; this is generally empty except
for advanced use.}
}
\value{
A list of length 2 with the \code{outputHash}, which is the digest
that Cache uses for \code{cacheId} and also \code{preDigest}, which is
the digest of each sub-element in \code{objsToDigest}.
}
\description{
This can be used by a user to pre-test their arguments before running
\code{Cache}, for example to determine whether there is a cached copy.
}
\examples{
\dontrun{
  a <- Cache(rnorm, 1)
  CacheDigest(list(rnorm, 1))

}
}
