% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{crossoverResidualAnalysis}
\alias{crossoverResidualAnalysis}
\title{crossoverResidualAnalysis}
\usage{
crossoverResidualAnalysis(file, StudyID, ExperimentNames, Type, Metrics)
}
\arguments{
\item{file}{The dataset to be analysed.}

\item{StudyID}{A character string used to identify the origin of the dataset}

\item{ExperimentNames}{A vector of one or more strings variables identifying each experiment in the file.}

\item{Type}{A vector of string variables identifying the design for each experiment. Each element should have the value '2G' or '4G'}

\item{Metrics}{A vector of string variables identifying the variables to be analysed.}
}
\value{
The results of analysing the residuals for each experiment and metric using the Anderson-Darling test (ADpval) and the number of outliers (NUmOut).
}
\description{
This function analyses one or more crossover experiments where each experiment can be either a two group or four group experiment as specified by Type parameter. The file parameter includes a dataset comprising one or more experiments as defined by the ExperimentNames parameter and each experiment includes values for every output variable defined in the Metrics parameter. After being analysed using the linear modeling lmer function of the lme4 package, the residuals are assessed for normality based on  the Anderson-Darling test. Warning 1. This function should only be used with data sets that include one or more individual crossover experiments in the format used in the datasets reported in the reproducer package that were used in the paper B. Kitchenham, L. Madeyski, G. Scanniello, and C. Gravino, “The importance of the correlation between results from individual participants in crossover studies,” IEEE Transactions in SoftwareEngineering, 2021 (Accepted for Publication). [Online]. Available: https://doi.org/10.1109/TSE.2021.30. Warning 2. The lmer function assumes that when experiments include multiple data from the same participant, the correlation between measures for the same participant will be positive. If there is no positive correlation, the function will deliver the warning: boundary (singular) fit: see ?isSingular. This does not mean the analysis has failed. It means that the within participant and between participant variance are set to the same value.
}
\examples{
File=reproducer::KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE
crossoverResidualAnalysis(
  File,StudyID='S1',ExperimentNames=c('USB2'),Type=c('4G'),
  Metrics=c('Correctness','Time','Efficiency'))
#  Study  Exp     Metrics  N ADpval NumOut
#1    S1 USB2 Correctness 24 0.0846      2
#2    S1 USB2        Time 24 0.0448      1
#3    S1 USB2  Efficiency 24  0.365      4
}
\author{
Barbara Kitchenham and Lech Madeyski
}
