% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello17TOSEM}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello17TOSEM}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello17TOSEM data}
\format{
A data frame with 200 rows and 17 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each of the experiments in the
data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A , B , C, D}
\item{System}{<fct>|Software systems used in the experiments: The Unibas experiment used Agenda
(a system for tracking personal contacts) and Gas-Station (a system for managing a petrol
station). The UniNa experiment used Financial (a system which is a command line option price
calculator) and Hotel-Reservation. The POLINA and PROF experiments used AveCalc (a system that
manages as electronic register and LaTazza  (a system for a drinks vending machine).}
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct>|Experimental Treatment:ABBR, abbreviated names. FULL, full names}
\item{Time}{<dbl>|Dependent variable: The time each participant spent performing the SE task.}
\item{FMeasure}{<dbl>|Dependent variable: The effectiveness of the participants taking into
account correctness and completeness of the fault fixing tasks}
\item{Efficiency}{<dbl>|Dependent variable: The ratio of effectiveness to time. }
\item{CrossOverID}{<fct>|CrossOver category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. For 2 group crossover,
the category is set to CO1 only.}
\item{Language}{<fct>|Java or C. The language was the same for all participants in a specific
experiment. POLINA and PROF used Java, UNIBAS and UNINA used C.}
\item{Ident}{<dbl>|Dependent variable: The number of faults identified.}
\item{Fixed}{<dbl>|Dependent variable: The number of faults identified.}
\item{WrongIdent}{<dbl>|Dependent variable: The number of faults incorrectly identified}
\item{WronglyFixed}{<dbl>|Dependent variable: The number of faults incorrectly fixed.}
\item{precision}{<dbl>|Dependent variable: The ratio of number of faults correctly fixed to the
number of faults correctly identified.}
\item{recall}{<dbl>|Dependent variable: The ratio of number of faults correctly fixed to the
total number of fault.}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello17TOSEM
}
\description{
Data illustrate correlations between results from individual participants in a family of four
cross-over experiments conducted by Scanniello et al.:
[1] G. Scanniello, M. Risi, P. Tramontana, and S. Romano, 'Fixing faults in C and Java source
code: Abbreviated vs. full-word identifier names', ACM Transactions on Software Engineering
Methodology, vol. 26, no. 2, 2017.
The experiments assess whether whether the use of abbreviated identifier names (ABBR), impacts
the effectiveness of fault fixing in C and Java source code in comparison with full-word
identifier names (FULL).
If you use this data set please cite:
[1] G. Scanniello, M. Risi, P. Tramontana, and S. Romano, “Fixing faults in C and Java source
code: Abbreviated vs. full-word identifier names', ACM Transactions on Software Engineering
Methodology, vol. 26, no. 2, 2017.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, 'On the
Importance of the Correlation between Results from Individual Participants in Crossover
Experiments' (to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello17TOSEM

}
\keyword{datasets}
