% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculateLargeSampleRandomizedBlockDesignEffectSizes}
\alias{calculateLargeSampleRandomizedBlockDesignEffectSizes}
\title{calculateLargeSampleRandomizedBlockDesignEffectSizes}
\usage{
calculateLargeSampleRandomizedBlockDesignEffectSizes(
  meanC = 0,
  sdC = 1,
  diff,
  N = 5e+06,
  type = "n",
  Blockmean = 0,
  StdAdj = 0
)
}
\arguments{
\item{meanC}{to act as the mean of the distribution (default 0) used to
generate the control group data (note for the gamma distribution this is the
rate parameter and must not be zero)}

\item{sdC}{the variance/spread of the distribution (default 1) used to
generate the control group data.}

\item{diff}{a value added to meanC to generate the treatment group data
(default 0).}

\item{N}{the size of each group (default 5000000)}

\item{type}{the distribution of the data to be generated. One of: 'n' for
normal (default), 'l' for log-normal, 'g' for gamma, and 'lap' for Laplace.}

\item{Blockmean, }{a value that can be added one of the blocks to represent
a fixed block effect (default 0).}

\item{StdAdj}{a value that can be added to sdC to introduce heterogeneity
into the tretament group (default 0).}
}
\value{
A tibble identifying the sample statistics and the values of the
probability of superiority, Cliff's d and StdMD (labelled StdES)
}
\description{
The function uses a simulates a large experiment  to estimate the asymptotic values of the probability of superiority, Cliff's d and the standardized mean difference data for a four group randomized blocks experiment for four different distributions: Normal (i.e. type='n'), log-normal (i.e. type='l'), gama (i.e. tyep='g') and Laplace (i.e., type='lap').
}
\examples{
set.seed=400
calculateLargeSampleRandomizedBlockDesignEffectSizes(
  meanC=0, sdC=1, diff=.5, N=100000, type='n',Blockmean=0.5,StdAdj = 0)
#  MeanC   SdC MeanT   SdT    BE  Phat Cliffd   UES   Var StdES
#  <dbl> <dbl> <dbl> <dbl> <dbl> <dbl>  <dbl> <dbl> <dbl> <dbl>
#1     0     1   0.5     1   0.5 0.638  0.277 0.501 0.998 0.502

}
\author{
Barbara Kitchenham and Lech Madeyski
}
