% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14EASE}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14EASE}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14EASE data illustrate correlations
between results from individual participants in a family of two cross-over experiments conducted
by Scanniello et al:
[1] G. Scanniello, M. Staron, H. Burden, and R. Heldal, "On the effect of using SysML
requirement diagrams to comprehend requirements: results from two controlled experiments," in
Proceedings of the 18th International Conference on Evaluation and Assessment in Software
Engineering, EASE. ACM, 2014.
The two experiments investigate whether requirements specified as SysML requirement diagrams
improve the comprehensibility of requirements.
If you use this data set please cite:
[1] G. Scanniello, M. Staron, H. Burden, and R. Heldal, "On the effect of using SysML
requirement diagrams to comprehend requirements: results from two controlled experiments",
in Proceedings of the 18th International Conference on Evaluation and Assessment in Software
Engineering, EASE. ACM, 2014.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).}
\format{
A data frame with 174 rows and 9 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each experiment in the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A (RD-NORD,Automobile-ESS),
B (NORD-RD,ESS-Automobile), C(NORD-RD,Automobile-ESS), D(RD-NORD,ESS-Automobile).}
\item{System}{<fct>|Software systems used in the experiment: Automobile: A system for
controlling car behavior with use cases about entering the car, anti-lock breaking or operating
the climate control of a car. ESS (Enhanced Security System) a system designed
to detect potential home intruders.}
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct>|Experimental Treatment: RD availability of a SysML requirements diagram
vs No requirements diagram (NORD)}
\item{Time}{<dbl>|Dependent variable: The time [min] required for the comprehension task.}
\item{Comprehension}{<dbl>|Dependent variable: The comprehension level the software engineer
achieved. }
\item{CrossOverID}{<fct>|CrossOver category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. For 2 group crossover,
the category is set to CO1 only}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14EASE
}
\description{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14EASE data illustrate correlations
between results from individual participants in a family of two cross-over experiments conducted
by Scanniello et al:
[1] G. Scanniello, M. Staron, H. Burden, and R. Heldal, "On the effect of using SysML
requirement diagrams to comprehend requirements: results from two controlled experiments," in
Proceedings of the 18th International Conference on Evaluation and Assessment in Software
Engineering, EASE. ACM, 2014.
The two experiments investigate whether requirements specified as SysML requirement diagrams
improve the comprehensibility of requirements.
If you use this data set please cite:
[1] G. Scanniello, M. Staron, H. Burden, and R. Heldal, "On the effect of using SysML
requirement diagrams to comprehend requirements: results from two controlled experiments",
in Proceedings of the 18th International Conference on Evaluation and Assessment in Software
Engineering, EASE. ACM, 2014.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello14EASE

}
\keyword{datasets}
