% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{NP4GroupMetaAnalysisSimulation}
\alias{NP4GroupMetaAnalysisSimulation}
\title{NP4GroupMetaAnalysisSimulation}
\usage{
NP4GroupMetaAnalysisSimulation(
  mean,
  sd,
  diff,
  GroupSize,
  Exp = 5,
  type = "n",
  alpha = 0.05,
  seed = 123,
  StdAdj = 0,
  BlockEffect = 0,
  BlockStdAdj = 0,
  StdExp = 0,
  MAMethod,
  returnES = FALSE
)
}
\arguments{
\item{mean}{The default value used for the group means in the simulated data. It can be any real number including zero.}

\item{sd}{The default value used for the spread of the control group and the spread of the treatment group in the simulated data. The value must be a real value greater than 0.}

\item{diff}{mean+diff is the value used for the mean of the treatment group. It can be zero.}

\item{GroupSize}{is the size of each of the 4 groups comprising one experiment. GroupSize should be an integer of 4 or more}

\item{Exp}{is the number of experiments being simulated. Exp should be an integer of 2 or more. It defaults to 5.}

\item{type}{specifies the distribution being simulated. The permitted values are "n" for the normal distribution,  "l" for the lognormal distribution, "g" for the gamma distribution and "lap" for the Laplace dsitribution. The parameter defaults to "n".}

\item{alpha}{The Type 1 value used in all significance tests. It defaults to 0.05.}

\item{seed}{specifies the seed to be used to initiate the simulation, so the simulation is repeatable. It defaults to 123.}

\item{StdAdj}{The value used to introduce heterogeneity into the treatment groups variance if required.}

\item{BlockEffect}{is the effect of having two different blocks}

\item{BlockStdAdj}{is the variance associated with the Block. If BlockStdAdj is zero it means we are treat the block effect as a fixed effect. If BlockStdAdj>0, we treat the block effect as a random effect and increase the variance of Block 2 data.}

\item{StdExp}{The value used to introduce heterogeneity into experiments in a family required.}

\item{MAMethod}{defines the method used for meta-analysis}

\item{returnES}{default to FALSE}
}
\value{
If returnES is true, the function returns the summary meta-analysis summary statistics otherwise the function returns the effect sizes for each experiment
}
\description{
This function simulates data from a family of experiments, where the number of experiments in a family is defined by ther parameter Exp. It simulates data from one of four distributions and uses the data to construct four of groups of equal size (GroupSize). Two groups are assigned as control groups and their distribution is based on the parameter mean and the parameter spread, however, the mean and spread for the control group in Block 2 can be adjusted using the parameters BlockEffect and BlockStdAdj respectively. The other two groups are treatment groups and their distribution is based on the mean+diff and the spread parameter, but the distributions can be adjusted using the StdAdj, BlockEffect and BlockStdAdj parameters. The data from each experiment is analysed separately to estimate the non-parametric statistics P-hat, Cliff's d and Kendall's tau and their variances. The statistics are then meta-analysed using the method specified by the MAMethod parameter. We output the average non-parametric effect statistics across the Exp experimet as if from a single large experiment and also the results of meta-analysising each non-parametric effect size. We use the standard parametric effect sizes and their meta-analysis as baselines. All tests of significance are done at the 0.05 level.
}
\examples{
NP4GroupMetaAnalysisSimulation(mean=0,sd=1,diff=0.5,GroupSize=10,Exp=5,type="n",alpha=0.05,
seed=123,StdAdj=0,BlockEffect=0.5,BlockStdAdj=0,StdExp=0,MAMethod="PM")
# A tibble: 1 x 30
#  NumExp GroupSize AveKtau AveKtauctvar tauSigCVt AveCliffd AveCliffdvar AveCliffdsig Avephat
# Avephatvar Avephatsig
#   <dbl>     <dbl>   <dbl>        <dbl> <lgl>         <dbl>        <dbl> <lgl>          <dbl>
# <dbl> <lgl>
# 1      5        10   0.182      0.00188 TRUE          0.346      0.00673 TRUE           0.673
# 0.00163 TRUE
# … with 19 more variables: MAMean <dbl>, MAvar <dbl>, MASig <lgl>, QE <dbl>, QEp <dbl>,
# HetSig <lgl>, P.mean <dbl>,
NP4GroupMetaAnalysisSimulation(mean=0,sd=1,diff=0.724,GroupSize=10,Exp=5,type="l",alpha=0.05,
seed=123,StdAdj=0,BlockEffect=0.5,BlockStdAdj=0,StdExp=0,MAMethod="PM")
# A tibble: 1 x 30
#  NumExp GroupSize AveKtau AveKtauctvar tauSigCVt AveCliffd AveCliffdvar AveCliffdsig Avephat
# Avephatvar Avephatsig
#   <dbl>     <dbl>   <dbl>        <dbl> <lgl>         <dbl>        <dbl> <lgl>          <dbl>
#  <dbl> <lgl>
# 1      5        10   0.244      0.00167 TRUE          0.464      0.00593 TRUE           0.732
# 0.00144 TRUE
# … with 19 more variables: MAMean <dbl>, MAvar <dbl>, MASig <lgl>, QE <dbl>, QEp <dbl>,
# HetSig <lgl>, P.mean <dbl>,
NP4GroupMetaAnalysisSimulation(mean=0,sd=1,diff=0.5,GroupSize=10,Exp=5,type="n",alpha=0.05,
seed=123,StdAdj=0,BlockEffect=0.5,BlockStdAdj=0,StdExp=0,MAMethod="PM",returnES=TRUE)
# A tibble: 5 x 16
#  MeanExp VarExp StdESExp    df  tval   tpval    tciL  tciU Cliffd Cliffdvar  PHat PHatvar
# PHatdf     g gvar.approx
#    <dbl>  <dbl>    <dbl> <dbl> <dbl>   <dbl>   <dbl> <dbl>  <dbl>     <dbl> <dbl>   <dbl>
# <dbl> <dbl>       <dbl>
#1   0.940  0.783    1.06   31.3 3.36  0.00206  0.370  1.51   0.58     0.0243 0.29  0.00587
# 30.2 1.04       0.112
#2   0.372  0.943    0.383  35.0 1.21  0.234   -0.251  0.996  0.21     0.0380 0.105 0.00927
# 31.3 0.375      0.0977
#3   0.598  0.619    0.761  28.6 2.40  0.0229   0.0892 1.11   0.37     0.0336 0.185 0.00813
# 30.8 0.740      0.104
#4   0.873  1.13     0.821  28.1 2.60  0.0148   0.184  1.56   0.440    0.0333 0.220 0.00813
# 23.8 0.799      0.106
#5   0.243  1.03     0.240  31.5 0.758 0.454   -0.410  0.896  0.13     0.0390 0.065 0.00946
# 32.8 0.234      0.0961
# … with 1 more variable: Cohendvar <dbl>
}
\author{
Barbara Kitchenham and Lech Madeyski
}
