% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{MadeyskiKitchenham.EUBASdata}
\alias{MadeyskiKitchenham.EUBASdata}
\title{MadeyskiKitchenham.EUBASdata data}
\format{A data frame with variables:
\describe{
\item{ID}{Project ID}
\item{TimePeriod}{Period of time (run): R1, R2}
\item{SequenceGroup}{Sequence group: G1, G2, G3, G4}
\item{System}{Software system identificator indicates the system (i.e., S1 or S2) used as the experimental object: S1. A software system to sell and manage CDs/DVDs in a music shop, S2. A software system to book and buy theater tickets}
\item{Technique}{The independent variable. It is a nominal variable that can assume the following two values: AM (analysis models plus source code) and SC (source code alone)}
\item{Comp_Level}{This denotes the comprehension level of the source code achieved by a software engineer}
\item{Modi_Level}{This denotes the capability of a maintainer to modify source code}
}}
\source{
\url{http://madeyski.e-informatyka.pl/reproducible-research/}
}
\usage{
MadeyskiKitchenham.EUBASdata
}
\description{
If you use this data set please cite this R package and the paper where we analyze the data set: Lech Madeyski and Barbara Kitchenham, "Effect Sizes and their Variance for AB/BA Crossover Design Studies" (submitted).
}
\details{
Data set comes from an experiment conducted in Italy at the University of Basilicata (with 24 first-year students from the Master's Program in Computer Science) to answer the question "Do the software models produced in the requirements analysis process aid in the comprehensibility and modifiability of source code?", see G. Scanniello, C. Gravino, M. Genero, J. A. Cruz-Lemus, and G. Tortora, "On the Impact of UML Analysis Models on Source-code Comprehensibility and Modifiability," ACM Transactions on Software Engineering and Methodology, vol. 23, pp. 13:1-13:26, Apr. 2014. However, the inconsistent subject data for subject 2 was removed, see the aforementioned paper by Madeyski and Kitchenham.
}
\examples{
MadeyskiKitchenham.EUBASdata

}
\keyword{datasets}
