% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MadeyskiKitchenhamMetaAnalysis.R
\name{getEffectSizesABBAIgnoringPeriodEffect}
\alias{getEffectSizesABBAIgnoringPeriodEffect}
\title{getEffectSizesABBAIgnoringPeriodEffect}
\usage{
getEffectSizesABBAIgnoringPeriodEffect(simulationData)
}
\arguments{
\item{simulationData}{- data set in a form required to calculate effect sizes in AB/BA crossover experimental designs}
}
\value{
data frame incl. calculated effect sizes and variances:
# dIG.ipe - independent groups standardized effect size
# var.dIG.ipe - variance of independent groups standardized effect size
# dRM.ipe - repeated measures (within-subjects) standardized effect size
# var.dRM.ipe - variance of repeated measures (within-subjects) standardized effect size
# dIG.Fromt.ipe - independent groups standardized effect size calculated from t: dIG.Fromt=t*sqrt(1-r)*sqrt((N1+N2)/(2*N1*N2))
# var.dIG.Fromt.ipe - variance of independent groups standardized effect size calculated from t: var.dIG.Fromt=var.t*(1-r)*((N1+N2)/(2*N1*N2))
# dRM.Fromt.ipe - dRM calculated from t: dRM.Fromt=t*sqrt((N1+N2)/(2*N1*N2))
# var.dRM.Fromt.ipe - var.dRM calculated from t: var.dRM.Fromt = var.t*((N1+N2)/(2*N1*N2))
# var.dRM.Fromt2.ipe - var.dRM calculated from t or rather dRM.Fromt: var.dRM.Fromt2=(df/(df-2))*((N1+N2)/(2*N1*N2)+dRM.Fromt^2)- dRM.Fromt^2/c^2
# unstandardizedES.ipe - estimated unstandardized technique effect size
# var.sig.ipe - sum of within-subjects variance and between-subjects variance
# var.within.ipe - within-subjects variance
# var.between.ipe - between-subjects variance
# t.ipe - t-value
# var.t.ipe - variance of t-variable
}
\description{
Function to calculate both effect sizes (dIG.ipe, dRM.ipe), i.e., independent groups and repeated measures standardized effect sizes and variances, for AB/BA crossover design studies ignoring period effect (thus wrong). Function was removed in the revision of the paper "Effect Sizes and their Variance for AB/BA Crossover Design Studies" by Lech Madeyski and Barbara Kitchenham.
}
\examples{
simulationData<-getSimulationData(25, 18.75, 50, 10, 5, 500) #generate simulated data set
es.ipe<-getEffectSizesABBAIgnoringPeriodEffect(simulationData) #return effect sizes and variances
}
\author{
Lech Madeyski and Barbara Kitchenham
}

