% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_put}
\alias{repo_put}
\title{Create a new item in the repository.}
\usage{
repo_put(obj, name = NULL, description = NULL, tags = NULL, prj = NULL,
  src = NULL, chunk = name, depends = NULL, replace = F, asattach = F,
  to = NULL, addversion = F, URL = NULL, checkRelations = T)
}
\arguments{
\item{obj}{An R object to store in the repo.}

\item{name}{A character identifier for the new item. If NULL, the
name of the \code{obj} variable will be used.}

\item{description}{A character description of the item.}

\item{tags}{A list of tags to sort the item. Tags are useful for
selecting sets of items and run bulk actions.}

\item{prj}{The name of a \code{project} item in the repository (see
\code{project}). Default is no associated project item.}

\item{src}{Name of an existing item to be annotated as the
"generator" of the new item. Usually it is an attachment item
containing the source code that generated the new item. Default
is NULL.}

\item{chunk}{The name of the code chunk within \code{src} that is
responsible for building the item. Set to \code{name} by
default. See \code{build}.}

\item{depends}{Character vector: items that depend on this
item. Default is NULL.}

\item{replace}{One of: V, F, "addversion" to define behavior when
an item by the same name exists. If V, overwrite it. If F stop
with an error. If "addversion" the new item is stored as a new
version and the old item is renamed by appending a "#N"
suffix. Default is F.}

\item{asattach}{Specifies that the item is to be treated as an
attachment (see attach). Default is F.}

\item{to}{Vector of character. Specifies which item this item is
attached to. Default is NULL.}

\item{addversion}{Deprecated, use the \code{replace} parameter
instead.}

\item{URL}{Remote URL where the \code{pull} function expects to
download actual item data from. Default is NULL.}

\item{checkRelations}{Check if items referenced by this item
exist. Default is T.}
}
\value{
Used for side effects.
}
\description{
Given an R object, stores it to an RDS file in the \code{repo} root
and add an associated item to the \code{repo} index, including
object name, description, tags and more.
}
\details{
The item \code{name} can be any string, however it should
    be a concise identifier, possibly without special character
    (could become mandatory soon). Some tags have a special
    meaning, like "hide" (do not show the item by default),
    "attachment" (the item is an attachment - this should never be
    set manually), "stash" (the item is a stashed item, makes the
    item over-writable by other "stash" items by default).
}
\examples{
## Repository creation
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)

## Producing some irrelevant data
data1 <- 1:10
data2 <- data1 * 2
data3 <- data1 / 2

## Putting the data in the database, specifying dependencies
rp$put(
    obj = data1,
    name = "item1",
    description = "First item",
    tags = c("repo_put", "a_random_tag"),
    )
rp$put(data2, "item2", "Item dependent on item1",
    "repo_dependencies", depends="item1")
rp$put(data3, "item3", "Item dependent on item1 and item2",
    "repo_dependencies", depends=c("item1", "item2"))

print(rp)

## Creating another version of item1
data1.2 <- data1 + runif(10)
rp$put(data1.2, name = "item1", "First item with additional noise",
    tags = c("repo_put", "a_random_tag"), replace="addversion")
print(rp, all=TRUE)
rp$info("item1#1")

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
get, set, attach, info
}
